/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.dialog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import matteroverdrive.api.dialog.IDialogOption;
import matteroverdrive.api.exceptions.MORuntimeException;
import matteroverdrive.data.dialog.DialogMessage;
import matteroverdrive.data.dialog.DialogOptionReference;
import matteroverdrive.handler.dialog.DialogRegistry;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOLog;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class DialogAssembler {
    private static final ResourceLocation dialogLocation = new ResourceLocation("matteroverdrive:dialog/dialog.json");
    private static final String customDialogPath = "custom_dialog.json";
    private String currentDialogName;

    public void loadDialogs(DialogRegistry dialogRegistry) {
        String path = "/assets/" + dialogLocation.func_110624_b() + "/" + dialogLocation.func_110623_a();
        InputStream inputStream = DialogAssembler.class.getResourceAsStream(path);
        this.loadDialogs(inputStream, dialogRegistry);
    }

    public void loadCustomDialogs(DialogRegistry dialogRegistry) {
        File file = new File(customDialogPath);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                this.loadDialogs(inputStream, dialogRegistry);
            }
            catch (FileNotFoundException e) {
                MOLog.log(Level.ERROR, e, "Could not find Custom quests file", new Object[0]);
            }
        } else {
            MOLog.info("No custom dialog file found at: %s", file.getAbsolutePath());
        }
    }

    private void loadDialogs(InputStream inputStream, DialogRegistry dialogRegistry) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        JsonParser jsonParser = new JsonParser();
        JsonObject mainQuestsObject = jsonParser.parse((Reader)inputStreamReader).getAsJsonObject();
        for (JsonElement element : mainQuestsObject.getAsJsonArray("dialogs")) {
            if (!element.isJsonObject()) continue;
            this.currentDialogName = MOJsonHelper.getString(element.getAsJsonObject(), "id");
            DialogMessage dialogMessage = this.parseMessage(element.getAsJsonObject(), dialogRegistry);
            if (dialogMessage == null) continue;
            dialogRegistry.registerMessage(new ResourceLocation(this.currentDialogName), dialogMessage);
        }
    }

    public DialogMessage parseMessage(JsonObject jsonObject, DialogRegistry dialogRegistry) {
        DialogMessage dialogMessage = new DialogMessage(jsonObject);
        if (jsonObject.has("options") && jsonObject.get("options").isJsonArray()) {
            JsonArray array = jsonObject.getAsJsonArray("options");
            for (int i = 0; i < array.size(); ++i) {
                JsonElement element = array.get(i);
                IDialogOption option = this.parseOption(element, dialogRegistry);
                if (option == null) continue;
                dialogMessage.addOption(option);
            }
        }
        return dialogMessage;
    }

    public IDialogOption parseOption(JsonElement element, DialogRegistry dialogRegistry) {
        if (element.isJsonObject()) {
            DialogMessage optionMessage = this.parseMessage(element.getAsJsonObject(), dialogRegistry);
            if (element.getAsJsonObject().has("id")) {
                dialogRegistry.registerMessage(new ResourceLocation(MOJsonHelper.getString(element.getAsJsonObject(), "id")), optionMessage);
            } else {
                dialogRegistry.registerMessage(optionMessage);
            }
            return optionMessage;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            ResourceLocation location = new ResourceLocation(element.getAsString());
            DialogOptionReference optionReference = new DialogOptionReference(location);
            return optionReference;
        }
        throw new MORuntimeException(String.format("Dialog Option must be of type string or Object at: '%s'", new Object[0]));
    }
}

