/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.thread.VersionCheckThread;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class VersionCheckerHandler
implements IConfigSubscriber {
    public static final String[] mirrors = new String[]{"https://api.cfwidget.com/mc-mods/minecraft/229694-matter-overdrive"};
    final String regex = "([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)";
    final Pattern pattern = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)");
    public Future<String> download;
    int lastPoll = 400;
    private boolean updateInfoDisplayed = false;
    private int currentMirror = 0;
    private boolean checkForUpdates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || Platform.isDev() || event.phase != TickEvent.Phase.START || !this.checkForUpdates) {
            return;
        }
        if (FMLCommonHandler.instance().getSide() == Side.SERVER && FMLCommonHandler.instance().getMinecraftServerInstance().func_71278_l() && !event.player.func_70003_b(2, "")) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (this.updateInfoDisplayed) {
            return;
        }
        if (this.currentMirror < mirrors.length && this.download == null) {
            this.download = MatterOverdrive.THREAD_POOL.submit(new VersionCheckThread(mirrors[this.currentMirror]));
            ++this.currentMirror;
        }
        if (this.download != null && this.download.isDone()) {
            String result = null;
            try {
                result = this.download.get();
            }
            catch (InterruptedException e) {
                MOLog.log(Level.ERROR, e, "Version checking from '%1$s' was interrupted", mirrors[this.currentMirror - 1]);
            }
            catch (ExecutionException e) {
                MOLog.log(Level.ERROR, e, "Version checking from '%1$s' has failed", mirrors[this.currentMirror - 1]);
            }
            finally {
                if (result != null) {
                    try {
                        this.updateInfoDisplayed = this.constructVersionAndCheck(result, event.player);
                    }
                    catch (Exception e) {
                        MOLog.log(Level.ERROR, e, "There was a problem while decoding the update info from website.", new Object[0]);
                    }
                }
                this.download.cancel(false);
                this.download = null;
            }
        }
    }

    private boolean constructVersionAndCheck(String jsonText, EntityPlayer player) {
        String[] arr;
        JsonParser parser = new JsonParser();
        JsonObject root = parser.parse(jsonText).getAsJsonObject();
        JsonObject versions = root.get("versions").getAsJsonObject();
        JsonArray versionData = versions.get("1.12.2").getAsJsonArray();
        int data = 0;
        JsonObject latest = versionData.get(0).getAsJsonObject();
        String type = latest.get("type").getAsString();
        if (type.equals("alpha")) {
            while (type.equals("alpha") && versionData.size() > data) {
                latest = versionData.get(data++).getAsJsonObject();
            }
        }
        if (type.equals("alpha")) {
            return false;
        }
        String fileName = latest.get("name").getAsString();
        Matcher matcher = this.pattern.matcher(fileName);
        if (!matcher.find()) {
            return false;
        }
        String fullVersion = matcher.group(0);
        boolean hasNew = false;
        if (!"0.7.0.0".equals(fullVersion) && Integer.parseInt((arr = "0.7.0.0".split("\\."))[0]) >= Integer.parseInt(matcher.group(1)) && Integer.parseInt(arr[1]) >= Integer.parseInt(matcher.group(2)) && Integer.parseInt(arr[2]) >= Integer.parseInt(matcher.group(3))) {
            if (matcher.groupCount() == 5 && arr.length == 4) {
                if (Integer.parseInt(arr[3]) >= Integer.parseInt(matcher.group(4))) {
                    hasNew = true;
                }
            } else {
                hasNew = true;
            }
        }
        if (hasNew) {
            TextComponentString chat = new TextComponentString(TextFormatting.GOLD + "[Matter Overdrive] ");
            Style style = new Style();
            chat.func_150257_a((ITextComponent)new TextComponentTranslation("alert.new_update", new Object[0])).func_150255_a(style.func_150238_a(TextFormatting.WHITE));
            player.func_145747_a((ITextComponent)chat);
            chat = new TextComponentString("");
            ITextComponent versionName = new TextComponentString(root.get("title").getAsString() + " " + fullVersion + " ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA));
            chat.func_150257_a(versionName);
            chat.func_150258_a(TextFormatting.WHITE + "[");
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/matter-overdrive"));
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentTranslation("info.matteroverdrive.updater.hover", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))));
            style.func_150238_a(TextFormatting.GREEN);
            chat.func_150257_a((ITextComponent)new TextComponentTranslation("info.matteroverdrive.updater.download", new Object[0])).func_150255_a(style);
            chat.func_150258_a(TextFormatting.WHITE + "]");
            player.func_145747_a((ITextComponent)chat);
            return true;
        }
        MOLog.info("Matter Overdrive Version %1$s is up to date.", "0.7.0.0");
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        String comment = "Should Matter Overdrive check for newer versions, every time the world starts";
        this.checkForUpdates = config.getBool("version_check", "client", true, comment);
        config.config.get("client", "version_check", true).setComment(comment);
    }
}

