/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.server.PacketBioticActionKey;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KeyHandler {
    public static final int MATTER_SCANNER_GUI = 0;
    public static final int ABILITY_USE_KEY = 1;
    public static final int ABILITY_SWITCH_KEY = 2;
    private static final String[] keyDesc = new String[]{"Open Matter Scanner GUI", "Android Ability key", "Android Switch Ability key"};
    private static final int[] keyValues = new int[]{46, 45, 19};
    private final KeyBinding[] keys = new KeyBinding[keyValues.length];

    public KeyHandler() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new KeyBinding(keyDesc[i], keyValues[i], "Matter Overdrive");
            ClientRegistry.registerKeyBinding((KeyBinding)this.keys[i]);
        }
    }

    @SubscribeEvent
    public void onClientTick(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_147113_T() || Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g);
        if (androidPlayer.isAndroid() && ClientProxy.keyHandler.getBinding(1).func_151468_f()) {
            for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
                int level = androidPlayer.getUnlockedLevel(stat);
                if (level <= 0 || !stat.isEnabled(androidPlayer, level)) continue;
                stat.onActionKeyPress(androidPlayer, androidPlayer.getUnlockedLevel(stat), false);
            }
            MatterOverdrive.NETWORK.sendToServer(new PacketBioticActionKey());
        }
    }

    public void manageBiostats(int keyCode, boolean state) {
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g);
        if (androidPlayer.isAndroid()) {
            for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
                int level = androidPlayer.getUnlockedLevel(stat);
                if (level <= 0 || !stat.isEnabled(androidPlayer, level)) continue;
                stat.onKeyPress(androidPlayer, androidPlayer.getUnlockedLevel(stat), keyCode, state);
            }
        }
    }

    public KeyBinding getBinding(int id) {
        return this.keys[id];
    }
}

