/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.init.MatterOverdriveEntities;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityHandler {
    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntityLiving() instanceof EntityPlayer && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityLiving())).isAndroid()) {
            androidPlayer.onEntityFall(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            MOPlayerCapabilityProvider.GetAndroidCapability(event.getEntity()).sync(EnumSet.allOf(IAndroid.DataType.class));
            MOPlayerCapabilityProvider.GetExtendedCapability(event.getEntity()).sync(EnumSet.allOf(PlayerQuestData.DataType.class));
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntityLiving() instanceof EntityPlayer && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityLiving())) != null && androidPlayer.isAndroid()) {
            androidPlayer.onEntityJump(event);
            androidPlayer.triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        AndroidPlayer newAndroidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityPlayer());
        AndroidPlayer oldAndroidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getOriginal());
        if (newAndroidPlayer != null && oldAndroidPlayer != null) {
            newAndroidPlayer.copy(oldAndroidPlayer);
            if (event.isWasDeath()) {
                newAndroidPlayer.onPlayerRespawn();
            }
            newAndroidPlayer.sync(EnumSet.allOf(IAndroid.DataType.class));
        }
        OverdriveExtendedProperties newExtendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer());
        OverdriveExtendedProperties oldExtenderDProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getOriginal());
        if (newExtendedProperties != null && oldExtenderDProperties != null) {
            newExtendedProperties.copy(oldExtenderDProperties);
            newExtendedProperties.sync(EnumSet.allOf(PlayerQuestData.DataType.class));
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityLiving()).triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent deathEvent) {
        if (deathEvent.getSource() != null && deathEvent.getSource().func_76346_g() instanceof EntityPlayer) {
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability(deathEvent.getSource().func_76346_g());
            extendedProperties.onEvent((Event)deathEvent);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntityLiving() instanceof EntityPlayer && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityLiving())).isAndroid()) {
            androidPlayer.onEntityHurt(event);
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        if (event.getEntityLiving() != null) {
            OverdriveExtendedProperties extendedProperties;
            if (!event.getItem().func_92059_d().func_190926_b() && MatterHelper.containsMatter(event.getItem().func_92059_d())) {
                for (int i = 0; i < 9; ++i) {
                    if (event.getEntityPlayer().field_71071_by.func_70301_a(i).func_190926_b() || event.getEntityPlayer().field_71071_by.func_70301_a(i).func_77973_b() != MatterOverdrive.ITEMS.portableDecomposer) continue;
                    MatterOverdrive.ITEMS.portableDecomposer.decomposeItem(event.getEntityPlayer().field_71071_by.func_70301_a(i), event.getItem().func_92059_d());
                }
            }
            if ((extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)event.getEntityPlayer())) != null) {
                extendedProperties.onEvent((Event)event);
            }
        }
    }

    @SubscribeEvent
    public void onEntityTransport(MOEventTransport eventTransport) {
        OverdriveExtendedProperties extendedProperties;
        if (eventTransport.getEntity() instanceof EntityPlayer && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability(eventTransport.getEntity())) != null) {
            extendedProperties.onEvent((Event)eventTransport);
        }
    }

    @SubscribeEvent
    public void onEntityAnomalyConsume(MOEventGravitationalAnomalyConsume.Post event) {
        OverdriveExtendedProperties extendedProperties;
        if (event.entity instanceof EntityPlayer && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability(event.entity)) != null) {
            extendedProperties.onEvent(event);
        }
    }

    @SubscribeEvent
    public void OnAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("MatterOverdrive: Legacy Edition", "MOPlayer"), (ICapabilityProvider)new MOPlayerCapabilityProvider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityVillager && ((EntityVillager)event.getEntity()).getProfessionForge().equals(MatterOverdriveEntities.MAD_SCIENTIST_PROFESSION) && !event.getEntity().getClass().equals(EntityVillagerMadScientist.class)) {
            event.setCanceled(true);
            EntityVillagerMadScientist villager = new EntityVillagerMadScientist(event.getWorld());
            villager.func_180482_a(event.getWorld().func_175649_E(((EntityVillager)event.getEntity()).func_190671_u_()), null);
            villager.func_70873_a(-24000);
            villager.func_70012_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 0.0f, 0.0f);
            event.getWorld().func_72838_d((Entity)villager);
            if (event.getEntity().func_145818_k_()) {
                villager.func_96094_a(event.getEntity().func_95999_t());
            }
        }
    }
}

