/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.gui.events.ITextHandler;
import matteroverdrive.gui.pages.AutoConfigPage;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;

public class MatterNetworkConfigPage
extends AutoConfigPage
implements ITextHandler {
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;
    private ElementInventorySlot filterSlot;
    private MOElementTextField destinationTextField;

    public MatterNetworkConfigPage(MOGuiMachine gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
        this.destinationTextField = new MOElementTextField((MOGuiBase)gui, this, 4, 42, 96, 16);
        this.destinationTextField.setName("Destination");
        this.destinationTextField.setBackground(MOElementButton.HOVER_TEXTURE_DARK);
        this.destinationTextField.setTextOffset(4, 3);
        this.componentMatterNetworkConfigs = ((MOTileEntityMachine)gui.getMachine()).getComponent(ComponentMatterNetworkConfigs.class);
        this.filterSlot = new ElementInventorySlot((MOGuiBase)gui, (MOSlot)this.machineGui.field_147002_h.func_75139_a(this.componentMatterNetworkConfigs.getDestinationFilterSlot()), 104, 37, 22, 22, "big");
    }

    @Override
    public void init() {
        super.init();
        this.addElement(this.destinationTextField);
        if (this.componentMatterNetworkConfigs != null) {
            if (this.componentMatterNetworkConfigs.getDestinationFilter() != null) {
                this.destinationTextField.setText(this.componentMatterNetworkConfigs.getDestinationFilter());
            }
            this.addElement(this.filterSlot);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        this.getFontRenderer().func_78276_b("Destination Address:", this.posX, this.posY + 28, 0xFFFFFF);
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
        if (elementName.equals("Destination") && this.componentMatterNetworkConfigs != null) {
            this.componentMatterNetworkConfigs.setDestinationFilter(text);
            ((MOTileEntityMachine)this.machineGui.getMachine()).sendConfigsToServer(false);
        }
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
    }
}

