/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class SidePannel
extends ElementBaseGroup {
    private static boolean isOpen;
    public final ScaleTexture BACKGROUND_TEXTURE = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/right_side_bar_panel_bg.png"), 15, 18).setOffsets(7, 7, 8, 9);
    MOElementButton button;
    private boolean openable;

    public SidePannel(MOGuiBase gui, int posX, int posY, int height) {
        this(gui, posX, posY, height, true);
    }

    public SidePannel(MOGuiBase gui, int posX, int posY, int height, boolean openable) {
        super(gui, posX, posY, 37, height);
        MOElementButtonScaled button = new MOElementButtonScaled(gui, this, 0, 0, "Toggle", 16, height);
        button.setNormalTexture(new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/right_side_bar_over.png"), 32, 143).setOffsets(0, 0, 42, 100));
        button.setOverTexture(new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/right_side_bar_over.png"), 32, 143).setOffsets(0, 0, 42, 100));
        button.setSounds(MatterOverdriveSounds.guiButtonExpand.func_187503_a());
        this.button = button;
        this.openable = openable;
    }

    @Override
    public void init() {
        super.init();
        if (this.button != null) {
            this.elements.add(this.button);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        if (this.openable) {
            if (isOpen) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.BACKGROUND_TEXTURE.render(this.posX, this.posY, 37, this.sizeY);
                this.button.setPosition(32, 0);
            } else {
                this.button.setPosition(0, 0);
            }
        }
        super.drawBackground(mouseX, mouseY, ticks);
    }

    public boolean isOpen() {
        return isOpen;
    }

    public void setOpen(boolean open) {
        isOpen = open;
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        if (buttonName.equals("Toggle")) {
            isOpen = !isOpen;
        }
    }

    @Override
    public void update() {
        if (this.openable) {
            if (isOpen) {
                this.button.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.close_menu", new Object[0]));
                this.setSize(53, this.sizeY);
            } else {
                this.button.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.open_menu", new Object[0]));
                this.setSize(37, this.sizeY);
            }
        }
    }

    @Override
    public void updateInfo() {
        for (MOElementBase element : this.elements) {
            element.setVisible(isOpen);
        }
        this.button.setVisible(this.openable);
    }

    public void setOpenable(boolean openable) {
        this.openable = openable;
    }
}

