/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementListBox;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MatterDatabaseListBox
extends MOElementListBox {
    private static final ResourceLocation ACTIVE_SLOT_BG = ElementSlot.getTexture("big_main_active");
    private static final ResourceLocation SLOT_BG = ElementSlot.getTexture("big");
    public ItemStack scanner;
    public String filter = "";

    public MatterDatabaseListBox(MOGuiBase gui, int x, int y, int width, int height, ItemStack scanner) {
        super(gui, x, y, width, height);
        this.scanner = scanner;
    }

    public MOGuiBase getGui() {
        return this.gui;
    }

    @Override
    protected boolean shouldBeDisplayed(IMOListBoxElement element) {
        return element.getName().toLowerCase().contains(this.filter.toLowerCase());
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void updateList(List<ItemPattern> patternList) {
        this.clear();
        ItemPattern selected = MatterScanner.getSelectedAsPattern(this.scanner);
        if (patternList != null) {
            for (int i = 0; i < patternList.size(); ++i) {
                if (selected.equals(patternList.get(i))) {
                    this._selectedIndex = i;
                }
                MatterDatabaseEntry selectedEntry = new MatterDatabaseEntry(patternList.get(i));
                this.add(selectedEntry);
            }
        }
    }

    @Override
    protected void onSelectionChanged(int newIndex, IMOListBoxElement newElement) {
        MatterDatabaseEntry entry = (MatterDatabaseEntry)newElement;
        MatterScanner.setSelected(this.scanner, entry.itemComp);
        this.gui.handleElementButtonClick(this, this.name, newIndex);
    }

    class MatterDatabaseEntry
    implements IMOListBoxElement {
        ItemPattern itemComp;
        String name;

        public MatterDatabaseEntry(ItemPattern itemComp) {
            this.itemComp = itemComp;
            this.name = itemComp.toItemStack(false).func_82833_r();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public int getWidth() {
            return 25;
        }

        @Override
        public Object getValue() {
            return this.itemComp;
        }

        @Override
        public void draw(MOElementListBox listBox, int x, int y, int backColor, int textColor, boolean selected, boolean BG) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (BG) {
                if (selected) {
                    MatterDatabaseListBox.this.gui.bindTexture(ACTIVE_SLOT_BG);
                    MatterDatabaseListBox.this.gui.drawSizedTexturedModalRect(x, y, 0, 0, 38, 22, 38.0f, 22.0f);
                } else {
                    MatterDatabaseListBox.this.gui.bindTexture(SLOT_BG);
                    MatterDatabaseListBox.this.gui.drawSizedTexturedModalRect(x, y, 0, 0, 22, 22, 22.0f, 22.0f);
                }
            } else {
                ItemStack itemStack = this.itemComp.toItemStack(false);
                RenderUtils.renderStack(3 + x, 3 + y, itemStack);
            }
        }

        @Override
        public void drawToolTop(MOElementListBox listBox, int x, int y) {
            ItemStack item = this.itemComp.toItemStack(false);
            List tooltip = item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            tooltip.add("Progress: " + this.itemComp.getProgress() + "%");
            tooltip.add("Matter: " + MatterHelper.getMatterAmountFromItem(item) + " kM");
            ((MatterDatabaseListBox)listBox).getGui().setTooltip(tooltip);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

