/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementItemPreview
extends MOElementBase {
    ScaleTexture background = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/item_preview_bg.png"), 40, 48).setOffsets(22, 22, 18, 18);
    ItemStack itemStack;
    float itemSize = 2.0f;
    boolean renderOverlay;
    boolean drawTooltip;

    public ElementItemPreview(MOGuiBase gui, int posX, int posY, ItemStack itemStack) {
        super(gui, posX, posY);
        this.sizeX = 47;
        this.sizeY = 47;
        this.itemStack = itemStack;
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void addTooltip(List<String> tooltip, int mouseX, int mouseY) {
        tooltip.addAll(this.itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
    }

    public void setItemSize(float itemSize) {
        this.itemSize = itemSize;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.background != null) {
            this.background.render(this.posX, this.posY, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.itemStack != null) {
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)((float)(this.posX + this.sizeX / 2) - 9.0f * this.itemSize), (float)((float)(this.posY + this.sizeY / 2) - 9.0f * this.itemSize), (float)0.0f);
            GlStateManager.func_179152_a((float)this.itemSize, (float)this.itemSize, (float)this.itemSize);
            RenderUtils.renderStack(0, 0, 32, this.itemStack, this.renderOverlay);
            GlStateManager.func_179121_F();
        }
    }

    public void setRenderOverlay(boolean renderOverlay) {
        this.renderOverlay = renderOverlay;
    }

    public void setDrawTooltip(boolean drawTooltip) {
        this.drawTooltip = drawTooltip;
    }

    public void setBackground(ScaleTexture background) {
        this.background = background;
    }
}

