/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.gui.GuiElementList;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.events.ITextHandler;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class ElementBaseGroup
extends MOElementBase
implements IButtonHandler,
GuiElementList,
ITextHandler {
    protected final ArrayList<MOElementBase> elements = new ArrayList();

    public ElementBaseGroup(MOGuiBase gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementBaseGroup(MOGuiBase gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
    }

    @Override
    public void init() {
        this.elements.clear();
    }

    protected MOElementBase getElementAtPosition(int mX, int mY) {
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase element = this.getElements().get(i);
            if (mY < 0 || mY > this.sizeY || mX < 0 || mX > this.sizeX || !element.intersectsWith(mX, mY) || !element.isVisible()) continue;
            return element;
        }
        return null;
    }

    @Override
    public void addTooltip(List<String> var1, int mouseX, int mouseY) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase element = this.getElements().get(i);
            if (mouseY < 0 || mouseY > this.sizeY || mouseX < 0 || mouseX > this.sizeX || !element.intersectsWith(mouseX, mouseY) || !element.isVisible()) continue;
            element.addTooltip(var1, mouseX, mouseY);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible()) continue;
            c.drawBackground(mouseX, mouseY, gameTicks);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible()) continue;
            c.drawForeground(mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        int i = this.elements.size();
        while (i-- > 0) {
            this.getElements().get(i).update(mouseX, mouseY, partialTicks);
        }
        this.update();
    }

    @Override
    public void updateInfo() {
        int i = this.elements.size();
        while (i-- > 0) {
            MOElementBase element = this.elements.get(i);
            element.updateInfo();
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        for (MOElementBase child : this.elements) {
            if (!child.isVisible() || !child.isEnabled()) continue;
            child.onMouseReleased(mouseX, mouseY);
        }
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        mouseX -= this.posX;
        mouseY -= this.posY;
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMouseWheel(mouseX, mouseY, movement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return true;
        }
        return false;
    }

    public MOElementBase setGroupVisible(boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
    }

    public List<MOElementBase> getElements() {
        return this.elements;
    }

    public void clearElements() {
        this.elements.clear();
    }

    public MOElementBase addElementAt(int i, MOElementBase element) {
        element.parent = this;
        this.elements.add(i, element);
        return element;
    }

    @Override
    public MOElementBase addElement(MOElementBase element) {
        if (element == null) {
            return null;
        }
        element.parent = this;
        this.elements.add(element);
        return element;
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }
}

