/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.container.ContainerDimensionalPylon;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementDoubleCircleBar;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.machines.dimensional_pylon.TileEntityMachineDimensionalPylon;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiDimensionalPylon
extends MOGuiMachine<TileEntityMachineDimensionalPylon> {
    ElementDoubleCircleBar powerBar;
    DecimalFormat format = new DecimalFormat("#.###");

    public GuiDimensionalPylon(InventoryPlayer inventoryPlayer, TileEntityMachineDimensionalPylon machine) {
        super(new ContainerDimensionalPylon(inventoryPlayer, machine), machine, 256, 230);
        this.name = "dimensional_pylon";
        this.powerBar = new ElementDoubleCircleBar(this, 70, 40, 135, 135, Reference.COLOR_GUI_ENERGY);
        this.powerBar.setColorRight(Reference.COLOR_HOLO);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.powerBar);
        this.AddHotbarPlayerSlots(this.field_147002_h, this, "small", null, 60, this.field_147000_g - 27);
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        IMatterHandler storage = ((TileEntityMachineDimensionalPylon)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null);
        this.powerBar.setProgressRight((float)storage.getMatterStored() / (float)storage.getCapacity());
        this.powerBar.setProgressLeft((float)((TileEntityMachineDimensionalPylon)this.machine).getEnergyStorage().getEnergyStored() / (float)((TileEntityMachineDimensionalPylon)this.machine).getEnergyStorage().getMaxEnergyStored());
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            ContainerDimensionalPylon container = (ContainerDimensionalPylon)this.getContainer();
            String info = "Efficiency";
            int width = this.field_146289_q.func_78256_a(info);
            this.field_146289_q.func_78276_b(info, 140 - width / 2, 132, Reference.COLOR_GUI_DARKER.getColor());
            info = DecimalFormat.getPercentInstance().format(((TileEntityMachineDimensionalPylon)this.machine).getDimensionalValue());
            width = this.field_146289_q.func_78256_a(info);
            this.field_146289_q.func_78276_b(info, 140 - width / 2, 142, Reference.COLOR_GUI_DARKER.getColor());
            double angle = -2.73318560862312 * (double)this.powerBar.getProgressLeft() - 0.18849555921538758;
            int xPos = 137 + (int)Math.round(Math.sin(angle) * 76.0);
            int yPos = 104 + (int)Math.round(Math.cos(angle) * 74.0);
            this.func_73732_a(this.field_146289_q, this.format.format(this.powerBar.getProgressLeft() * 100.0f) + "%", xPos, yPos, Reference.COLOR_HOLO_RED.getColor());
            angle = 2.73318560862312 * (double)this.powerBar.getProgressRight() + 0.18849555921538758;
            xPos = 137 + (int)Math.round(Math.sin(angle) * 76.0);
            yPos = 104 + (int)Math.round(Math.cos(angle) * 74.0);
            this.func_73732_a(this.field_146289_q, this.format.format(this.powerBar.getProgressRight() * 100.0f) + "%", xPos, yPos, Reference.COLOR_MATTER.getColor());
            info = "+" + container.getEnergyGenPerTick() + MOEnergyHelper.ENERGY_UNIT + "/t";
            width = this.field_146289_q.func_78256_a(info);
            xPos = 138 - width / 2;
            yPos = 110;
            this.field_146289_q.func_175063_a(info, (float)xPos, (float)yPos, Reference.COLOR_HOLO_RED.getColor());
            info = "-" + this.format.format(container.getMatterDrainPerSec()) + " kM" + "/s";
            width = this.field_146289_q.func_78256_a(info);
            xPos = 138 - width / 2;
            yPos = 98;
            this.field_146289_q.func_175063_a(info, (float)xPos, (float)yPos, Reference.COLOR_MATTER.getColor());
            info = "Charge: " + ((TileEntityMachineDimensionalPylon)this.machine).getCharge();
            width = this.field_146289_q.func_78256_a(info);
            xPos = 138 - width / 2;
            yPos = 86;
            this.field_146289_q.func_175063_a(info, (float)xPos, (float)yPos, Reference.COLOR_MATTER.getColor());
        }
    }
}

