/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.player;

import java.util.ArrayList;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventQuest;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.network.packet.client.quest.PacketSyncQuests;
import matteroverdrive.network.packet.client.quest.PacketUpdateQuest;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OverdriveExtendedProperties {
    public static final String EXT_PROP_NAME = "MOPlayer";
    @CapabilityInject(value=OverdriveExtendedProperties.class)
    public static Capability<OverdriveExtendedProperties> CAPIBILITY;
    private final EntityPlayer player;
    private final PlayerQuestData questData;

    public OverdriveExtendedProperties(EntityPlayer player) {
        this.player = player;
        this.questData = new PlayerQuestData(this);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(OverdriveExtendedProperties.class, (Capability.IStorage)new Capability.IStorage<OverdriveExtendedProperties>(){

            public NBTBase writeNBT(Capability<OverdriveExtendedProperties> capability, OverdriveExtendedProperties instance, EnumFacing side) {
                NBTTagCompound data = new NBTTagCompound();
                instance.saveNBTData(data);
                return data;
            }

            public void readNBT(Capability<OverdriveExtendedProperties> capability, OverdriveExtendedProperties instance, EnumFacing side, NBTBase nbt) {
                instance.loadNBTData((NBTTagCompound)nbt);
            }
        }, OverdriveExtendedProperties.class);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound questNBT = new NBTTagCompound();
        this.questData.writeToNBT(questNBT, EnumSet.allOf(PlayerQuestData.DataType.class));
        compound.func_74782_a("QuestData", (NBTBase)questNBT);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound questNBT = compound.func_74775_l("QuestData");
        this.questData.readFromNBT(questNBT, EnumSet.allOf(PlayerQuestData.DataType.class));
    }

    public void sync(EnumSet<PlayerQuestData.DataType> dataTypes) {
        if (this.player != null && !this.player.field_70170_p.field_72995_K && this.player instanceof EntityPlayerMP) {
            MatterOverdrive.NETWORK.sendTo(new PacketSyncQuests(this.questData, dataTypes), (EntityPlayerMP)this.player);
        }
    }

    public void copy(OverdriveExtendedProperties oterExtendetProperies) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        oterExtendetProperies.saveNBTData(tagCompound);
        this.loadNBTData(tagCompound);
    }

    public void addQuest(QuestStack questStack) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventQuest.Added(questStack, this.player))) {
            if (this.isServer()) {
                QuestStack addedQuest;
                if (this.questData.getActiveQuests().size() <= 0 && this.questData.getCompletedQuests().size() <= 0) {
                    ItemStack scanner = new ItemStack((Item)MatterOverdrive.ITEMS.dataPad);
                    scanner.func_151001_c("Scientist's Data Pad");
                    MatterOverdrive.ITEMS.dataPad.addToScanWhitelist(scanner, Blocks.field_150459_bM);
                    MatterOverdrive.ITEMS.dataPad.addToScanWhitelist(scanner, Blocks.field_150469_bN);
                    MatterOverdrive.ITEMS.dataPad.addToScanWhitelist(scanner, Blocks.field_150464_aj);
                    scanner.func_77978_p().func_74757_a("Destroys", true);
                    this.player.func_191521_c(scanner);
                }
                if ((addedQuest = this.questData.addQuest(questStack)) != null) {
                    addedQuest.getQuest().initQuestStack(this.player.func_70681_au(), addedQuest, this.player);
                    MatterOverdrive.NETWORK.sendTo(new PacketUpdateQuest(addedQuest, 1), (EntityPlayerMP)this.player);
                }
            } else {
                QuestStack addedQuest = this.questData.addQuest(questStack);
                ClientProxy.questHud.addStartedQuest(addedQuest);
            }
        }
    }

    public void update(Side side) {
        if (side.equals((Object)Side.SERVER)) {
            this.questData.manageQuestCompletion();
        }
    }

    public boolean hasCompletedQuest(QuestStack questStack) {
        return this.questData.hasCompletedQuest(questStack);
    }

    public boolean hasQuest(QuestStack questStack) {
        return this.questData.hasQuest(questStack);
    }

    public void onQuestCompleted(QuestStack questStack, int index) {
        if (this.isServer()) {
            ArrayList<IQuestReward> rewards = new ArrayList<IQuestReward>();
            questStack.addRewards(rewards, this.getPlayer());
            int xp = questStack.getXP(this.getPlayer());
            MOEventQuest.Completed event = new MOEventQuest.Completed(questStack, this.player, xp, rewards);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                this.questData.addQuestToCompleted(questStack);
                this.getPlayer().func_71023_q(event.xp);
                for (IQuestReward reward : event.rewards) {
                    reward.giveReward(questStack, this.getPlayer());
                }
                questStack.getQuest().onCompleted(questStack, this.player);
                this.player.func_145747_a((ITextComponent)new TextComponentString(String.format("[Matter Overdrive] %1$s completed %2$s", this.player.func_145748_c_().func_150254_d(), questStack.getTitle(this.player))));
            }
            MatterOverdrive.NETWORK.sendTo(new PacketUpdateQuest(index, null, questStack, 2), (EntityPlayerMP)this.player);
        } else {
            ClientProxy.questHud.addCompletedQuest(questStack);
            this.getQuestData().getCompletedQuests().add(questStack);
            this.getQuestData().removeQuest(index);
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiDataPad) {
                ((GuiDataPad)Minecraft.func_71410_x().field_71462_r).refreshQuests(this);
            }
        }
    }

    public void onQuestAbandoned(QuestStack questStack) {
        if (!this.isServer() && Minecraft.func_71410_x().field_71462_r instanceof GuiDataPad) {
            ((GuiDataPad)Minecraft.func_71410_x().field_71462_r).refreshQuests(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuestFromServer(int index, QuestStack questStack, QuestState questState) {
        if (index < this.getQuestData().getActiveQuests().size()) {
            ClientProxy.questHud.addObjectivesChanged(this.getQuestData().getActiveQuests().get(index), questStack, questState);
            this.getQuestData().getActiveQuests().set(index, questStack);
        }
    }

    public boolean isServer() {
        return this.player != null && !this.player.field_70170_p.field_72995_K;
    }

    public PlayerQuestData getQuestData() {
        return this.questData;
    }

    public void onEvent(Event event) {
        this.questData.onEvent(event);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

