/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Property;

public class EntityRogueAndroid
implements IConfigSubscriber {
    public static final HashSet<Integer> dimensionBlacklist = new HashSet();
    public static final HashSet<Integer> dimensionWhitelist = new HashSet();
    private static final HashSet<String> biomesBlacklist = new HashSet();
    private static final HashSet<String> biomesWhitelist = new HashSet();
    private static final List<Biome.SpawnListEntry> spawnListEntries = new ArrayList<Biome.SpawnListEntry>();
    public static float LEGENDARY_SPAWN_CHANCE;
    public static float SPAWN_CHANCE;
    public static int MAX_ANDROIDS_PER_CHUNK;
    public static boolean dropItems;

    public static void addAsBiomeGen(Class<? extends EntityLiving> entityClass) {
        spawnListEntries.add(new Biome.SpawnListEntry(entityClass, 15, 1, 2));
        EntityRogueAndroid.addInBiome(Biome.field_185377_q.iterator());
    }

    private static void addInBiome(Iterator<Biome> biomes) {
        EntityRogueAndroid.loadBiomeBlacklist(MatterOverdrive.CONFIG_HANDLER);
        EntityRogueAndroid.loadBiomesWhitelist(MatterOverdrive.CONFIG_HANDLER);
        while (biomes.hasNext()) {
            Biome biome = biomes.next();
            if (biome == null) continue;
            List spawnList = biome.func_76747_a(EnumCreatureType.MONSTER);
            for (Biome.SpawnListEntry entry : spawnListEntries) {
                if (!EntityRogueAndroid.isBiomeValid(biome) || spawnList.contains(entry) || entry.field_76292_a <= 0) continue;
                spawnList.add(entry);
            }
        }
    }

    private static boolean isBiomeValid(Biome biome) {
        if (biome != null) {
            if (biomesWhitelist.size() > 0) {
                return biomesWhitelist.contains(biome.getRegistryName().toString());
            }
            return !biomesBlacklist.contains(biome.getRegistryName().toString());
        }
        return false;
    }

    private static void loadBiomeBlacklist(ConfigurationHandler config) {
        String[] blacklist;
        biomesBlacklist.clear();
        for (String aBlacklist : blacklist = config.config.getStringList("biome.blacklist", "entities.rogue_android", new String[]{"minecraft:hell", "minecraft:sky", "minecraft:mushroom_island", "minecraft:mushroom_island_shore"}, "Rogue Android biome blacklist")) {
            biomesBlacklist.add(aBlacklist.toLowerCase());
        }
    }

    private static void loadBiomesWhitelist(ConfigurationHandler configurationHandler) {
        String[] whitelist;
        biomesWhitelist.clear();
        for (String aWhitelist : whitelist = configurationHandler.config.getStringList("biome.whitelist", "entities.rogue_android", new String[0], "Rogue Android biome whitelist")) {
            biomesBlacklist.add(aWhitelist.toLowerCase());
        }
    }

    private static void loadDimensionBlacklist(ConfigurationHandler configurationHandler) {
        int[] blacklist;
        dimensionBlacklist.clear();
        Property blacklistProp = configurationHandler.config.get("entities.rogue_android", "dimension.blacklist", new int[]{1});
        blacklistProp.setComment("Rogue Android Dimension ID blacklist");
        for (int aBlacklist : blacklist = blacklistProp.getIntList()) {
            dimensionBlacklist.add(aBlacklist);
        }
    }

    private static void loadDimesionWhitelist(ConfigurationHandler configurationHandler) {
        int[] whitelist;
        dimensionWhitelist.clear();
        Property whitelistProp = configurationHandler.config.get("entities.rogue_android", "dimension.whitelist", new int[0]);
        whitelistProp.setComment("Rogue Android Dimension ID whitelist");
        for (int item : whitelist = whitelistProp.getIntList()) {
            dimensionWhitelist.add(item);
        }
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        String category = "entities.rogue_android";
        int spawn_weight = config.config.getInt("spawn_weight", category, 25, 0, 100, "The spawn weight of Androids. This controls how likely are to be chosen to spawn next.");
        for (Biome.SpawnListEntry entry : spawnListEntries) {
            entry.field_76292_a = spawn_weight;
        }
        EntityRogueAndroid.loadDimensionBlacklist(config);
        EntityRogueAndroid.loadDimesionWhitelist(config);
        EntityRogueAndroid.loadBiomeBlacklist(config);
        EntityRogueAndroid.loadBiomesWhitelist(config);
        EntityRangedRogueAndroidMob.UNLIMITED_WEAPON_ENERGY = config.getBool("unlimited_weapon_energy", category, true, "Do Ranged Rogue Androids have unlimited weapon energy in their weapons");
        MAX_ANDROIDS_PER_CHUNK = config.getInt("max_android_per_chunk", category, 4, "The max amount of Rogue Android that can spawn in a given chunk");
        SPAWN_CHANCE = config.config.getFloat("spawn_chance_percent", category, 0.1f, 0.0f, 1.0f, "The spawn chance of rogue androids. How likely are they to spawn once chosen to spawn.");
        EntityRangedRogueAndroidMob.DROP_NORMAL_WEAPONS = config.getBool("drop_weapons", category, true, "Should normal Rogue Androids drop their weapons? If set to false they will never drop their weapons, but if set to true there is a small chance they will drop them.");
        EntityRangedRogueAndroidMob.DROP_LEGENDARY_WEAPONS = config.getBool("drop_legendary_weapons", category, true, "Should Legendary rogue androids drop Legendary weapons");
        LEGENDARY_SPAWN_CHANCE = config.config.getFloat("legendary_spawn_chance_percent", category, 0.03f, 0.0f, 1.0f, "The chance in percent, of rogue androids becoming legendary. This is the base value. This value is multiplied by the android's level");
        dropItems = config.config.getBoolean("do_drops", category, true, "Should the Rouge Androids drop any items");
    }

    static {
        MAX_ANDROIDS_PER_CHUNK = 4;
    }
}

