/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.android_player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import matteroverdrive.entity.android_player.AndroidPlayer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ObjectUtils;

public class AndroidEffects {
    private static final Map<Class<?>, Integer> typeMap = Maps.newHashMap();
    private final AndroidPlayer androidPlayer;
    private Map<Integer, Effect> effectMap = Maps.newHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean effectsChanged;

    public AndroidEffects(AndroidPlayer androidPlayer) {
        this.androidPlayer = androidPlayer;
    }

    public static void writeEffectsListToPacketBuffer(List<Effect> objectsList, ByteBuf buf) throws IOException {
        if (objectsList != null) {
            for (Effect effect : objectsList) {
                AndroidEffects.writeEffectToBuffer(buf, effect);
            }
        }
        buf.writeByte(127);
    }

    private static void writeEffectToBuffer(ByteBuf buf, Effect effect) throws IOException {
        int i = (effect.typeId << 5 | effect.id & 0x1F) & 0xFF;
        buf.writeByte(i);
        switch (effect.typeId) {
            case 0: {
                buf.writeByte((int)((Byte)effect.value).byteValue());
                break;
            }
            case 1: {
                buf.writeShort((int)((Short)effect.value).shortValue());
                break;
            }
            case 2: {
                buf.writeInt(((Integer)effect.value).intValue());
                break;
            }
            case 3: {
                buf.writeLong(((Long)effect.value).longValue());
                break;
            }
            case 4: {
                buf.writeFloat(((Float)effect.value).floatValue());
                break;
            }
            case 5: {
                buf.writeBoolean(((Boolean)effect.value).booleanValue());
                break;
            }
            case 6: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)effect.value));
                break;
            }
            case 7: {
                ItemStack itemstack = (ItemStack)effect.value;
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemstack);
                break;
            }
            case 8: {
                BlockPos blockpos = (BlockPos)effect.value;
                buf.writeInt(blockpos.func_177958_n());
                buf.writeInt(blockpos.func_177956_o());
                buf.writeInt(blockpos.func_177952_p());
                break;
            }
            case 9: {
                Rotations rotations = (Rotations)effect.value;
                buf.writeFloat(rotations.func_179415_b());
                buf.writeFloat(rotations.func_179416_c());
                buf.writeFloat(rotations.func_179413_d());
            }
        }
    }

    private static void writeEffectToNBT(NBTTagCompound tagCompound, Effect effect) {
        switch (effect.typeId) {
            case 0: {
                tagCompound.func_74774_a("value", ((Byte)effect.value).byteValue());
                break;
            }
            case 1: {
                tagCompound.func_74777_a("value", ((Short)effect.value).shortValue());
                break;
            }
            case 2: {
                tagCompound.func_74768_a("value", ((Integer)effect.value).intValue());
                break;
            }
            case 3: {
                tagCompound.func_74772_a("value", ((Long)effect.value).longValue());
                break;
            }
            case 4: {
                tagCompound.func_74776_a("value", ((Float)effect.value).floatValue());
                break;
            }
            case 5: {
                tagCompound.func_74757_a("value", ((Boolean)effect.value).booleanValue());
                break;
            }
            case 6: {
                tagCompound.func_74778_a("value", (String)effect.value);
                break;
            }
            case 7: {
                NBTTagCompound itemTag = new NBTTagCompound();
                ItemStack itemstack = (ItemStack)effect.value;
                itemstack.func_77955_b(itemTag);
                tagCompound.func_74782_a("value", (NBTBase)itemTag);
                break;
            }
            case 8: {
                NBTTagList blockTag = new NBTTagList();
                BlockPos blockpos = (BlockPos)effect.value;
                blockTag.func_74742_a((NBTBase)new NBTTagInt(blockpos.func_177958_n()));
                blockTag.func_74742_a((NBTBase)new NBTTagInt(blockpos.func_177956_o()));
                blockTag.func_74742_a((NBTBase)new NBTTagInt(blockpos.func_177952_p()));
                tagCompound.func_74782_a("value", (NBTBase)blockTag);
                break;
            }
            case 9: {
                Rotations rotations = (Rotations)effect.value;
                tagCompound.func_74782_a("value", (NBTBase)rotations.func_179414_a());
            }
        }
    }

    public static List<Effect> readEffectsListFromBuffer(ByteBuf buf) throws IOException {
        ArrayList list = null;
        byte i = buf.readByte();
        while (i != 127) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            int typeId = (i & 0xE0) >> 5;
            int id = i & 0x1F;
            Effect effect = null;
            switch (typeId) {
                case 0: {
                    effect = new Effect(id, buf.readByte(), typeId);
                    break;
                }
                case 1: {
                    effect = new Effect(id, buf.readShort(), typeId);
                    break;
                }
                case 2: {
                    effect = new Effect(id, buf.readInt(), typeId);
                    break;
                }
                case 3: {
                    effect = new Effect(id, buf.readLong(), typeId);
                    break;
                }
                case 4: {
                    effect = new Effect(id, Float.valueOf(buf.readFloat()), typeId);
                    break;
                }
                case 5: {
                    effect = new Effect(id, buf.readBoolean(), typeId);
                    break;
                }
                case 6: {
                    effect = new Effect(id, ByteBufUtils.readUTF8String((ByteBuf)buf), typeId);
                    break;
                }
                case 7: {
                    effect = new Effect(id, ByteBufUtils.readItemStack((ByteBuf)buf), typeId);
                    break;
                }
                case 8: {
                    int l = buf.readInt();
                    int i1 = buf.readInt();
                    int j1 = buf.readInt();
                    effect = new Effect(id, new BlockPos(l, i1, j1), typeId);
                    break;
                }
                case 9: {
                    float f = buf.readFloat();
                    float f1 = buf.readFloat();
                    float f2 = buf.readFloat();
                    effect = new Effect(id, new Rotations(f, f1, f2), typeId);
                }
            }
            list.add(effect);
            i = buf.readByte();
        }
        return list;
    }

    public static void readEffectFromNBT(NBTTagCompound tagCompound, Effect effect) {
        switch (effect.typeId) {
            case 0: {
                effect.value = tagCompound.func_74771_c("value");
                break;
            }
            case 1: {
                effect.value = tagCompound.func_74765_d("value");
                break;
            }
            case 2: {
                effect.value = tagCompound.func_74762_e("value");
                break;
            }
            case 3: {
                effect.value = tagCompound.func_74763_f("value");
                break;
            }
            case 4: {
                effect.value = Float.valueOf(tagCompound.func_74760_g("value"));
                break;
            }
            case 5: {
                effect.value = tagCompound.func_74767_n("value");
                break;
            }
            case 6: {
                effect.value = tagCompound.func_74779_i("value");
                break;
            }
            case 7: {
                NBTTagCompound itemTag = tagCompound.func_74775_l("value");
                effect.value = new ItemStack(itemTag);
                break;
            }
            case 8: {
                NBTTagList blockTag = tagCompound.func_150295_c("value", 3);
                effect.value = new BlockPos(((NBTTagInt)blockTag.func_179238_g(0)).func_150287_d(), ((NBTTagInt)blockTag.func_179238_g(1)).func_150287_d(), ((NBTTagInt)blockTag.func_179238_g(2)).func_150287_d());
                break;
            }
            case 9: {
                effect.value = new Rotations(tagCompound.func_150295_c("value", 5));
            }
        }
    }

    public Effect registerEffect(int id, Object value) {
        return this.registerEffect(id, value, false, false);
    }

    public Effect registerEffect(int id, Object value, boolean sendToOwner, boolean sendToOthers) {
        Integer dataType = typeMap.get(value.getClass());
        if (dataType == null) {
            throw new IllegalArgumentException("Unknown data type: " + value.getClass());
        }
        if (id > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + id + "! (Max is " + 31 + ")");
        }
        if (this.effectMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate id value for " + id + "!");
        }
        return this.effectMap.put(id, new Effect(id, value, dataType, sendToOwner, sendToOthers));
    }

    public byte getEffectByte(int id) {
        return (Byte)this.getEffect(id).value;
    }

    public short getEffectShort(int id) {
        return (Short)this.getEffect(id).value;
    }

    public int getEffectInt(int id) {
        return (Integer)this.getEffect(id).value;
    }

    public boolean getEffectBool(int id) {
        return (Boolean)this.getEffect(id).value;
    }

    public float getEffectFloat(int id) {
        return ((Float)this.getEffect(id).value).floatValue();
    }

    public long getEffectLong(int id) {
        return (Long)this.getEffect(id).value;
    }

    public String getEffectString(int id) {
        return (String)this.getEffect(id).value;
    }

    public ItemStack getEffectItemStack(int id) {
        return (ItemStack)this.getEffect(id).value;
    }

    public Rotations getWatchableObjectRotations(int id) {
        return (Rotations)this.getEffect(id).value;
    }

    private Effect getEffect(int id) {
        Effect effect;
        this.lock.readLock().lock();
        try {
            effect = this.effectMap.get(id);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting synched android effects data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synched android effects data");
            crashreportcategory.func_71507_a("Data ID", (Object)id);
            throw new ReportedException(crashreport);
        }
        this.lock.readLock().unlock();
        return effect;
    }

    public <T> void updateEffect(int id, T newData) {
        Effect effect = this.getEffect(id);
        if (!typeMap.get(newData.getClass()).equals(effect.typeId)) {
            throw new ClassCastException(String.format("Class: %s of value not the same as in stored effect", newData.getClass().getName()));
        }
        if (ObjectUtils.notEqual(newData, (Object)effect.value)) {
            effect.value = newData;
            this.androidPlayer.onEffectsUpdate(id);
            effect.setWatched(true);
            this.effectsChanged = true;
        }
    }

    public void setEffectWatched(int id) {
        this.getEffect(id).setWatched(true);
        this.effectsChanged = true;
    }

    public boolean haveEffectsChanged() {
        return this.effectsChanged;
    }

    public List<Effect> getChanged() {
        ArrayList list = null;
        if (this.effectsChanged) {
            this.lock.readLock().lock();
            for (Effect effect : this.effectMap.values()) {
                if (!effect.isWatched()) continue;
                effect.setWatched(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(effect);
            }
            this.lock.readLock().unlock();
        }
        this.effectsChanged = false;
        return list;
    }

    public void writeTo(ByteBuf buffer) throws IOException {
        this.lock.readLock().lock();
        for (Effect effect : this.effectMap.values()) {
            AndroidEffects.writeEffectToBuffer(buffer, effect);
        }
        this.lock.readLock().unlock();
        buffer.writeByte(127);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        for (Map.Entry<Integer, Effect> effectEntry : this.effectMap.entrySet()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            AndroidEffects.writeEffectToNBT(tagCompound, effectEntry.getValue());
            nbtTagCompound.func_74782_a(String.valueOf(effectEntry.getKey()), (NBTBase)tagCompound);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        for (Map.Entry<Integer, Effect> effectEntry : this.effectMap.entrySet()) {
            if (!tagCompound.func_74764_b(String.valueOf(effectEntry.getKey()))) continue;
            NBTTagCompound tag = tagCompound.func_74775_l(String.valueOf(effectEntry.getKey()));
            AndroidEffects.readEffectFromNBT(tag, effectEntry.getValue());
        }
    }

    public List<Effect> getAllWatched() {
        ArrayList list = null;
        this.lock.readLock().lock();
        for (Effect datawatcher$watchableobject : this.effectMap.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(datawatcher$watchableobject);
        }
        this.lock.readLock().unlock();
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEffectsFromList(List<Effect> effects) {
        this.lock.writeLock().lock();
        for (Effect effect : effects) {
            Effect existingEffect = this.effectMap.get(effect.id);
            if (existingEffect == null) continue;
            existingEffect.value = effect.value;
            this.androidPlayer.onEffectsUpdate(effect.id);
        }
        this.lock.writeLock().unlock();
        this.effectsChanged = true;
    }

    static {
        typeMap.put(Byte.class, 0);
        typeMap.put(Short.class, 1);
        typeMap.put(Integer.class, 2);
        typeMap.put(Long.class, 3);
        typeMap.put(Float.class, 4);
        typeMap.put(Boolean.class, 5);
        typeMap.put(String.class, 6);
        typeMap.put(ItemStack.class, 7);
        typeMap.put(BlockPos.class, 8);
        typeMap.put(Rotations.class, 9);
    }

    public static class Effect {
        private final int id;
        private final boolean sendToOwner;
        private final boolean sendToOthers;
        private final int typeId;
        private Object value;
        private boolean watched;

        public Effect(int id, Object value, int typeId) {
            this(id, value, typeId, false, false);
        }

        public Effect(int id, Object value, int typeId, boolean sendToOwner, boolean sendToOthers) {
            this.id = id;
            this.value = value;
            this.typeId = typeId;
            this.sendToOwner = sendToOwner;
            this.sendToOthers = sendToOthers;
            this.watched = true;
        }

        public boolean isWatched() {
            return this.watched;
        }

        public void setWatched(boolean watched) {
            this.watched = watched;
        }

        public boolean isSendToOthers() {
            return this.sendToOthers;
        }
    }
}

