/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogicRandomItem;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class QuestLogicCraft
extends AbstractQuestLogicRandomItem {
    int minCraftCount;
    int maxCraftCount;
    int xpPerCraft;

    public QuestLogicCraft() {
    }

    public QuestLogicCraft(ItemStack itemStack) {
        this(itemStack, 0, 0, 0);
    }

    public QuestLogicCraft(ItemStack itemStack, int minCraftCount, int maxCraftCount) {
        this(itemStack, minCraftCount, maxCraftCount, 0);
    }

    public QuestLogicCraft(ItemStack itemStack, int minCraftCount, int maxCraftCount, int xpPerCraft) {
        this.init(new QuestItem[]{QuestItem.fromItemStack(itemStack)}, minCraftCount, maxCraftCount, xpPerCraft);
    }

    public QuestLogicCraft(ItemStack[] itemStacks, int minCraftCount, int maxCraftCount, int xpPerCraft) {
        QuestItem[] questItems = new QuestItem[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            questItems[i] = QuestItem.fromItemStack(itemStacks[i]);
        }
        this.init(questItems, minCraftCount, maxCraftCount, xpPerCraft);
    }

    public QuestLogicCraft(QuestItem questItem, int minCraftCount, int maxCraftCount, int xpPerCraft) {
        this.init(new QuestItem[]{questItem}, minCraftCount, maxCraftCount, xpPerCraft);
    }

    public QuestLogicCraft(QuestItem[] questItem, int minCraftCount, int maxCraftCount, int xpPerCraft) {
        this.init(questItem, minCraftCount, maxCraftCount, xpPerCraft);
    }

    protected void init(QuestItem[] items, int minCraftCount, int maxCraftCount, int xpPerCraft) {
        this.init(items);
        this.minCraftCount = minCraftCount;
        this.maxCraftCount = maxCraftCount;
        this.xpPerCraft = xpPerCraft;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.minCraftCount = MOJsonHelper.getInt(jsonObject, "craft_count_min");
        this.maxCraftCount = MOJsonHelper.getInt(jsonObject, "craft_count_max");
        this.xpPerCraft = MOJsonHelper.getInt(jsonObject, "xp", 0);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$craftMaxAmount", Integer.toString(this.getMaxCraftCount(questStack)));
        info = info.replace("$craftItem", this.getItemName(questStack));
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getCraftCount(questStack) >= this.getMaxCraftCount(questStack);
    }

    public int getCraftCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("CraftCount");
        }
        return 0;
    }

    public void setCraftCount(QuestStack questStack, int count) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("CraftCount", count);
    }

    public int getMaxCraftCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxCraftCount");
        }
        return 0;
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = objective.replace("$craftAmount", Integer.toString(this.getCraftCount(questStack)));
        objective = objective.replace("$craftMaxAmount", Integer.toString(this.getMaxCraftCount(questStack)));
        objective = objective.replace("$craftItem", this.getItemName(questStack));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.initItemType(random, questStack);
        this.getTag(questStack).func_74768_a("MaxCraftCount", this.random(random, this.minCraftCount, this.maxCraftCount));
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof PlayerEvent.ItemCraftedEvent && ((PlayerEvent.ItemCraftedEvent)event).crafting != null && this.matches(questStack, ((PlayerEvent.ItemCraftedEvent)event).crafting) && this.getCraftCount(questStack) < this.getMaxCraftCount(questStack)) {
            this.setCraftCount(questStack, this.getCraftCount(questStack) + 1);
            if (this.isObjectiveCompleted(questStack, entityPlayer, 0)) {
                this.markComplete(questStack, entityPlayer);
                return new QuestLogicState(QuestState.Type.COMPLETE, true);
            }
            return new QuestLogicState(QuestState.Type.UPDATE, true);
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.xpPerCraft * this.getMaxCraftCount(questStack);
    }
}

