/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOQuestHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicBlockInteract
extends AbstractQuestLogic {
    private String regex;
    private boolean mustBeInteractable;
    private boolean destoryBlock;
    private QuestBlock block;

    public QuestLogicBlockInteract() {
    }

    public QuestLogicBlockInteract(String regex, boolean mustBeInteractable, boolean destoryBlock) {
        this.regex = regex;
        this.mustBeInteractable = mustBeInteractable;
        this.destoryBlock = destoryBlock;
    }

    public static void setBlockPosition(QuestStack questStack, BlockPos pos) {
        if (questStack.getTagCompound() == null) {
            questStack.setTagCompound(new NBTTagCompound());
        }
        questStack.getTagCompound().func_74772_a("pos", pos.func_177986_g());
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        if (jsonObject.has("block")) {
            this.block = new QuestBlock(jsonObject);
        }
        this.regex = MOJsonHelper.getString(jsonObject, "regex", null);
        this.mustBeInteractable = MOJsonHelper.getBool(jsonObject, "intractable", false);
        this.destoryBlock = MOJsonHelper.getBool(jsonObject, "destroy", false);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.hasInteracted(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        BlockPos pos = MOQuestHelper.getPosition(questStack);
        if (pos != null) {
            double distance = Math.sqrt(entityPlayer.func_180425_c().func_177951_i((Vec3i)pos));
            objective = objective.replace("$distance", Integer.toString((int)distance));
        }
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            PlayerInteractEvent interactEvent = (PlayerInteractEvent)event;
            if (!this.hasInteracted(questStack)) {
                BlockPos pos = MOQuestHelper.getPosition(questStack);
                if (pos != null && !pos.equals((Object)((PlayerInteractEvent)event).getPos())) {
                    return null;
                }
                if (this.mustBeInteractable) {
                    TileEntity tileEntity = interactEvent.getWorld().func_175625_s(interactEvent.getPos());
                    if (!(tileEntity instanceof IInteractionObject)) {
                        return null;
                    }
                    if (!(this.regex == null || ((IInteractionObject)tileEntity).func_145818_k_() && ((IInteractionObject)tileEntity).func_70005_c_().matches(this.regex))) {
                        return null;
                    }
                }
                if (this.destoryBlock && pos != null) {
                    ((PlayerInteractEvent)event).getWorld().func_175698_g(pos);
                }
                this.setInteracted(questStack, true);
                this.markComplete(questStack, entityPlayer);
                return new QuestLogicState(QuestState.Type.COMPLETE, true);
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public boolean hasInteracted(QuestStack questStack) {
        if (questStack.getTagCompound() != null) {
            return questStack.getTagCompound().func_74767_n("interacted");
        }
        return false;
    }

    public void setInteracted(QuestStack questStack, boolean interacted) {
        if (questStack.getTagCompound() == null) {
            questStack.setTagCompound(new NBTTagCompound());
        }
        questStack.getTagCompound().func_74757_a("interacted", interacted);
    }
}

