/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest;

import java.util.Random;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.GenericQuest;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class RandomQuestText
extends GenericQuest {
    int variationsCount;

    public RandomQuestText(IQuestLogic questLogic, String title, int variationsCount, int xpReward) {
        super(questLogic, title, xpReward);
        this.variationsCount = variationsCount;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack, EntityPlayer entityPlayer) {
        super.initQuestStack(random, questStack, entityPlayer);
        NBTTagCompound data = questStack.getTagCompound();
        if (data == null) {
            data = new NBTTagCompound();
            questStack.setTagCompound(data);
        }
        data.func_74777_a("Variation", (short)random.nextInt(this.variationsCount));
    }

    @Override
    public boolean areQuestStacksEqual(QuestStack questStackOne, QuestStack questStackTwo) {
        if (questStackOne == null && questStackTwo == null) {
            return true;
        }
        if (questStackOne.getTagCompound() == null && questStackTwo.getTagCompound() == null) {
            return super.areQuestStacksEqual(questStackOne, questStackTwo);
        }
        if (questStackOne.getTagCompound() != null && questStackTwo.getTagCompound() != null) {
            return super.areQuestStacksEqual(questStackOne, questStackTwo) && questStackOne.getTagCompound().func_74765_d("Variation") == questStackTwo.getTagCompound().func_74765_d("Variation");
        }
        return false;
    }

    public int getVariation(QuestStack questStack) {
        if (questStack.getTagCompound() != null) {
            return questStack.getTagCompound().func_74765_d("Variation");
        }
        return 0;
    }

    @Override
    public String getTitle(QuestStack questStack) {
        return this.questLogic.modifyTitle(questStack, MOStringHelper.translateToLocal("quest." + this.title + "." + this.getVariation(questStack) + ".title", new Object[0]));
    }

    @Override
    public String getTitle(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyTitle(questStack, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + "." + this.getVariation(questStack) + ".title", new Object[0]), entityPlayer));
    }

    @Override
    public String getInfo(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.questLogic.modifyInfo(questStack, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + "." + this.getVariation(questStack) + ".info", new Object[0]), entityPlayer));
    }

    @Override
    public String getObjective(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.questLogic.modifyObjective(questStack, entityPlayer, this.replaceVariables(MOStringHelper.translateToLocal("quest." + this.title + "." + this.getVariation(questStack) + ".objective." + objectiveIndex, new Object[0]), entityPlayer), objectiveIndex);
    }
}

