/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.matter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import matteroverdrive.data.matter.IMatterEntryHandler;
import matteroverdrive.data.matter.ItemStackHandlerCachable;
import matteroverdrive.data.matter.MatterEntryAbstract;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MatterEntryOre
extends MatterEntryAbstract<String, ItemStack> {
    public MatterEntryOre() {
    }

    public MatterEntryOre(String s) {
        super(s);
    }

    @Override
    public void writeTo(DataOutput output) throws IOException {
        int cachedCount = 0;
        for (IMatterEntryHandler handler : this.handlers) {
            if (!(handler instanceof ItemStackHandlerCachable)) continue;
            ++cachedCount;
        }
        output.writeInt(cachedCount);
        for (IMatterEntryHandler handler : this.handlers) {
            if (!(handler instanceof ItemStackHandlerCachable)) continue;
            ((ItemStackHandlerCachable)handler).writeTo(output);
        }
    }

    @Override
    public void writeTo(NBTTagCompound tagCompound) {
        NBTTagList handlers = new NBTTagList();
        for (IMatterEntryHandler handler : this.handlers) {
            if (!(handler instanceof ItemStackHandlerCachable)) continue;
            NBTTagCompound handlerTag = new NBTTagCompound();
            ((ItemStackHandlerCachable)handler).writeTo(handlerTag);
            handlers.func_74742_a((NBTBase)handlerTag);
        }
        tagCompound.func_74782_a("Handlers", (NBTBase)handlers);
    }

    @Override
    public void readFrom(DataInput input) throws IOException {
        this.clearAllCashed();
        int count = input.readInt();
        for (int i = 0; i < count; ++i) {
            ItemStackHandlerCachable genericHandler = new ItemStackHandlerCachable();
            genericHandler.readFrom(input);
            this.handlers.add(genericHandler);
        }
    }

    @Override
    public void readFrom(NBTTagCompound tagCompound) {
        this.clearAllCashed();
        NBTTagList tagList = tagCompound.func_150295_c("Handlers", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStackHandlerCachable genericHandler = new ItemStackHandlerCachable();
            genericHandler.readFrom(tagList.func_150305_b(i));
            this.handlers.add(genericHandler);
        }
    }

    @Override
    public void readKey(String data) {
        this.key = data;
    }

    @Override
    public String writeKey() {
        return (String)this.getKey();
    }

    @Override
    public boolean hasCached() {
        int cachedCount = 0;
        for (IMatterEntryHandler handler : this.handlers) {
            if (!(handler instanceof ItemStackHandlerCachable)) continue;
            ++cachedCount;
        }
        return cachedCount > 0;
    }

    public void clearAllCashed() {
        this.handlers.removeIf(itemStackIMatterEntryHandler -> itemStackIMatterEntryHandler instanceof ItemStackHandlerCachable);
    }
}

