/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidAttributes;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class BioticStatShield
extends AbstractBioticStat
implements IConfigSubscriber {
    private static final int SHIELD_COOLDOWN = 320;
    private static final int SHIELD_TIME = 160;
    private static int ENERGY_PER_TICK = 64;
    private static int ENERGY_PER_DAMAGE = 256;
    private final AttributeModifier modifyer;
    private final Random random;
    @SideOnly(value=Side.CLIENT)
    private MOPositionedSound shieldSound;

    public BioticStatShield(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.modifyer = new AttributeModifier(UUID.fromString("ead117ad-105a-43fe-ab22-a31aee6adc42"), "Shield Slowdown", -0.4, 2);
        this.random = new Random();
        this.setShowOnWheel(true);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K && android.getAndroidEffects().getEffectBool(2)) {
            android.extractEnergyScaled(ENERGY_PER_TICK);
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
        if (this.equals(androidPlayer.getActiveStat()) && this.canActivate(androidPlayer) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, androidPlayer))) {
            this.setShield(androidPlayer, true);
            androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS), true);
        }
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    void setShield(AndroidPlayer androidPlayer, boolean on) {
        androidPlayer.getAndroidEffects().updateEffect(2, on);
        this.setLastShieldTime(androidPlayer, androidPlayer.getPlayer().field_70170_p.func_82737_E() + 320L + 160L);
        androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS), true);
        androidPlayer.getPlayer().field_70170_p.func_184148_a(null, androidPlayer.getPlayer().field_70165_t, androidPlayer.getPlayer().field_70163_u, androidPlayer.getPlayer().field_70161_v, MatterOverdriveSounds.androidShieldPowerUp, SoundCategory.PLAYERS, 0.6f + this.random.nextFloat() * 0.2f, 1.0f);
    }

    @Override
    public String getDetails(int level) {
        String key = "Unknown";
        try {
            key = Keyboard.getKeyName((int)ClientProxy.keyHandler.getBinding(1).func_151463_i());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), key);
    }

    public boolean getShieldState(AndroidPlayer androidPlayer) {
        return androidPlayer.getAndroidEffects().getEffectBool(2);
    }

    private long getLastShieldTime(AndroidPlayer androidPlayer) {
        return androidPlayer.getAndroidEffects().getEffectLong(3);
    }

    private void setLastShieldTime(AndroidPlayer androidPlayer, long time) {
        androidPlayer.getAndroidEffects().updateEffect(3, time);
    }

    boolean canActivate(AndroidPlayer androidPlayer) {
        return this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E() <= 0L;
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingAttackEvent) {
            DamageSource source = ((LivingAttackEvent)event).getSource();
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingAttackEvent)event).getAmount() * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source) && event.isCancelable()) {
                    if (source.func_76346_g() != null) {
                        androidPlayer.getPlayer().field_70170_p.func_184148_a(null, androidPlayer.getPlayer().field_70165_t, androidPlayer.getPlayer().field_70163_u, androidPlayer.getPlayer().field_70161_v, MatterOverdriveSounds.androidShieldHit, SoundCategory.PLAYERS, 0.5f, 0.9f + this.random.nextFloat() * 0.2f);
                    }
                    if (androidPlayer.hasEnoughEnergyScaled(energyReqired)) {
                        androidPlayer.extractEnergyScaled(energyReqired);
                        event.setCanceled(true);
                    }
                }
            }
        } else if (event instanceof LivingHurtEvent) {
            DamageSource source = ((LivingHurtEvent)event).getSource();
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingHurtEvent)event).getAmount() * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source)) {
                    double energyMultiply = androidPlayer.getPlayer().func_110140_aT().func_111151_a(AndroidAttributes.attributeBatteryUse).func_111126_e();
                    energyReqired = (int)((double)energyReqired * energyMultiply);
                    int energyExtracted = androidPlayer.extractEnergy(energyReqired, true);
                    ((LivingHurtEvent)event).setAmount(((LivingHurtEvent)event).getAmount() + (float)energyExtracted / (float)energyReqired);
                }
            }
        }
    }

    boolean isDamageValid(DamageSource damageSource) {
        return damageSource.func_94541_c() || damageSource.func_76352_a();
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (androidPlayer.getPlayer().field_70170_p.field_72995_K) {
            if (!androidPlayer.getAndroidEffects().getEffectBool(2)) {
                this.stopShieldSound();
            } else {
                this.playShieldSound();
            }
        } else {
            long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
            if (shieldTime < 320L && androidPlayer.getAndroidEffects().getEffectBool(2)) {
                androidPlayer.getAndroidEffects().updateEffect(2, false);
                androidPlayer.getPlayer().field_70170_p.func_184148_a(null, androidPlayer.getPlayer().field_70165_t, androidPlayer.getPlayer().field_70163_u, androidPlayer.getPlayer().field_70161_v, MatterOverdriveSounds.androidShieldPowerDown, SoundCategory.PLAYERS, 0.6f + this.random.nextFloat() * 0.2f, 1.0f);
            }
        }
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playShieldSound() {
        if (this.shieldSound == null && !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            this.shieldSound = new MOPositionedSound(MatterOverdriveSounds.androidShieldLoop, SoundCategory.PLAYERS, 0.3f + this.random.nextFloat() * 0.2f, 1.0f);
            this.shieldSound.setRepeat(true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.shieldSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopShieldSound() {
        if (this.shieldSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.shieldSound);
            this.shieldSound = null;
        }
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK) && (shieldTime <= 0L || shieldTime > 320L);
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return this.getShieldState(androidPlayer);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.equals(android.getActiveStat()) || this.getShieldState(android);
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        if (shieldTime > 0L) {
            return (int)shieldTime;
        }
        return 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_DAMAGE = config.getInt("shield_energy_per_damage", "abilities", 256, "The energy cost of each hit to the shield");
        ENERGY_PER_TICK = config.getInt("shield_energy_per_tick", "abilities", 64, "The energy cost of the shield per tick");
    }
}

