/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.android.BionicStatGuiInfo;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.client.render.HoloIcons;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractBioticStat
implements IBioticStat {
    protected String name;
    boolean showOnHud;
    boolean showOnWheel;
    @SideOnly(value=Side.CLIENT)
    HoloIcon icon;
    private int xp;
    private IBioticStat root;
    private BionicStatGuiInfo guiInfo;
    private boolean rootMaxLevel;
    private List<IBioticStat> competitors;
    private List<ItemStack> requiredItems;
    private List<IBioticStat> enabledBlacklist;
    private int maxLevel;

    public AbstractBioticStat(String name, int xp) {
        this.name = name;
        this.xp = xp;
        this.competitors = new ArrayList<IBioticStat>();
        this.requiredItems = new ArrayList<ItemStack>();
        this.enabledBlacklist = new ArrayList<IBioticStat>();
        this.maxLevel = 1;
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    protected String getUnlocalizedDetails() {
        return "biotic_stat." + this.name + ".details";
    }

    @Override
    public String getDisplayName(AndroidPlayer androidPlayer, int level) {
        return MOStringHelper.translateToLocal("biotic_stat." + this.name + ".name", new Object[0]);
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return this.checkBlacklistActive(android, level);
    }

    public String getDetails(int level) {
        return MOStringHelper.translateToLocal("biotic_stat." + this.name + ".details", new Object[0]);
    }

    @Override
    public boolean canBeUnlocked(AndroidPlayer android, int level) {
        if (this.root != null && !android.isUnlocked(this.root, this.rootMaxLevel ? this.root.maxLevel() : 1)) {
            return false;
        }
        if (this.isLocked(android, level)) {
            return false;
        }
        if (this.requiredItems.size() > 0 && !android.getPlayer().field_71075_bZ.field_75098_d) {
            for (ItemStack item : this.requiredItems) {
                if (this.hasItem(android, item)) continue;
                return false;
            }
        }
        return android.isAndroid() && (android.getPlayer().field_71075_bZ.field_75098_d || android.getPlayer().field_71068_ca >= this.xp);
    }

    @Override
    public boolean isLocked(AndroidPlayer androidPlayer, int level) {
        return this.areCompeditrosUnlocked(androidPlayer);
    }

    protected boolean hasItem(AndroidPlayer player, ItemStack stack) {
        int amountCount = stack.func_190916_E();
        for (int i = 0; i < player.getPlayer().field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.getPlayer().field_71071_by.func_70301_a(i);
            if (s.func_190926_b() || !s.func_77969_a(stack)) continue;
            amountCount -= s.func_190916_E();
        }
        return amountCount <= 0;
    }

    @Override
    public void onUnlock(AndroidPlayer android, int level) {
        android.getPlayer().func_82242_a(-this.xp);
        this.consumeItems(android);
    }

    @Override
    public void onUnlearn(AndroidPlayer androidPlayer, int level) {
    }

    protected void consumeItems(AndroidPlayer androidPlayer) {
        for (ItemStack itemStack : this.requiredItems) {
            int itemCount = itemStack.func_190916_E();
            for (int j = 0; j < androidPlayer.getPlayer().field_71071_by.func_70302_i_(); ++j) {
                ItemStack pStack = androidPlayer.getPlayer().field_71071_by.func_70301_a(j);
                if (!pStack.func_190926_b() && pStack.func_77969_a(itemStack)) {
                    int countShouldTake = Math.min(itemCount, pStack.func_190916_E());
                    androidPlayer.getPlayer().field_71071_by.func_70298_a(j, countShouldTake);
                    itemCount -= countShouldTake;
                }
                if (itemCount > 0) continue;
                return;
            }
        }
    }

    @Override
    public void onTooltip(AndroidPlayer android, int level, List<String> list, int mouseX, int mouseY) {
        String[] detailsSplit;
        String name = TextFormatting.BOLD + this.getDisplayName(android, level);
        if (this.maxLevel() > 1) {
            name = name + TextFormatting.RESET + String.format(" [%s/%s]", level, this.maxLevel());
        }
        list.add(TextFormatting.WHITE + name);
        String details = this.getDetails(level + 1);
        for (String detail : detailsSplit = details.split("/n/")) {
            list.add(TextFormatting.GRAY + detail);
        }
        if (this.root != null) {
            String rootLevel = "";
            if (this.root.maxLevel() > 1 && this.rootMaxLevel) {
                rootLevel = " " + this.root.maxLevel();
            }
            list.add(TextFormatting.DARK_AQUA + MOStringHelper.translateToLocal("gui.tooltip.parent", new Object[0]) + ": " + TextFormatting.GOLD + String.format("[%s%s]", this.root.getDisplayName(android, 0), rootLevel));
        }
        StringBuilder requires = new StringBuilder();
        if (this.requiredItems.size() > 0) {
            for (ItemStack itemStack : this.requiredItems) {
                if (requires.length() > 0) {
                    requires.append(TextFormatting.GRAY + ", ");
                }
                if (itemStack.func_190916_E() > 1) {
                    requires.append(TextFormatting.DARK_GREEN.toString()).append(itemStack.func_190916_E()).append("x");
                }
                requires.append(TextFormatting.DARK_GREEN + "[").append(itemStack.func_82833_r()).append("]");
            }
        }
        if (requires.length() > 0) {
            list.add(TextFormatting.DARK_AQUA + MOStringHelper.translateToLocal("gui.tooltip.requires", new Object[0]) + ": " + requires);
        }
        if (this.competitors.size() > 0) {
            String locks = TextFormatting.RED + MOStringHelper.translateToLocal("gui.tooltip.locks", new Object[0]) + ": ";
            for (IBioticStat compeditor : this.competitors) {
                locks = locks + String.format("[%s] ", compeditor.getDisplayName(android, 0));
            }
            list.add(locks);
        }
        if (level < this.maxLevel()) {
            list.add((android.getPlayer().field_71068_ca < this.xp ? TextFormatting.RED : TextFormatting.GREEN) + "XP: " + this.xp);
        }
    }

    public boolean checkBlacklistActive(AndroidPlayer androidPlayer, int level) {
        for (IBioticStat stat : this.enabledBlacklist) {
            if (!stat.isActive(androidPlayer, level)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerIcons(TextureMap textureMap, HoloIcons holoIcons) {
        this.icon = holoIcons.registerIcon(textureMap, "biotic_stat_" + this.name, 18);
    }

    public void addReqiredItm(ItemStack stack) {
        this.requiredItems.add(stack);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.showOnHud;
    }

    @Override
    public boolean showOnWheel(AndroidPlayer androidPlayer, int level) {
        return this.showOnWheel;
    }

    @Override
    public int maxLevel() {
        return this.maxLevel;
    }

    @Override
    public IBioticStat getRoot() {
        return this.root;
    }

    public void setRoot(IBioticStat stat, boolean rootMaxLevel) {
        this.root = stat;
        this.rootMaxLevel = rootMaxLevel;
    }

    public void addCompetitor(IBioticStat stat) {
        this.competitors.add(stat);
    }

    public void removeCompetitor(IBioticStat competitor) {
        this.competitors.remove(competitor);
    }

    public List<IBioticStat> getCompetitors() {
        return this.competitors;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setShowOnHud(boolean showOnHud) {
        this.showOnHud = showOnHud;
    }

    public void setShowOnWheel(boolean showOnWheel) {
        this.showOnWheel = showOnWheel;
    }

    public void setGuiInfo(BionicStatGuiInfo guiInfo) {
        this.guiInfo = guiInfo;
    }

    @Override
    public BionicStatGuiInfo getGuiInfo(AndroidPlayer androidPlayer, int level) {
        return this.guiInfo;
    }

    @Override
    public List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }

    public List<IBioticStat> getEnabledBlacklist() {
        return this.enabledBlacklist;
    }

    public void addToEnabledBlacklist(IBioticStat stat) {
        this.enabledBlacklist.add(stat);
    }

    @Override
    public HoloIcon getIcon(int level) {
        return this.icon;
    }

    @Override
    public int getXP(AndroidPlayer androidPlayer, int level) {
        return this.xp;
    }

    public boolean areCompeditrosUnlocked(AndroidPlayer androidPlayer) {
        if (this.competitors.size() > 0) {
            for (IBioticStat competitor : this.competitors) {
                if (!androidPlayer.isUnlocked(competitor, 0)) continue;
                return true;
            }
        }
        return false;
    }
}

