/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.data.MatterStorage;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.tile.MOTileEntityMachineMatter;

public class MachineMatterStorage<T extends MOTileEntityMachineMatter>
extends MatterStorage {
    protected final T machine;

    public MachineMatterStorage(T machine, int capacity) {
        this(machine, capacity, capacity, capacity);
    }

    public MachineMatterStorage(T machine, int capacity, int maxExtract) {
        this(machine, capacity, maxExtract, maxExtract);
    }

    public MachineMatterStorage(T machine, int capacity, int maxExtract, int maxReceive) {
        super(capacity, maxExtract, maxReceive);
        this.machine = machine;
    }

    @Override
    public int getCapacity() {
        return Math.max(0, (int)((double)super.getCapacity() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterStorage)));
    }

    @Override
    public int getMaxExtract() {
        return Math.max(0, (int)((double)super.getMaxExtract() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterTransfer)));
    }

    @Override
    public int getMaxReceive() {
        return Math.max(0, (int)((double)super.getMaxReceive() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterTransfer)));
    }

    @Override
    public int extractMatter(int amount, boolean simulate) {
        int extracted = super.extractMatter(amount, simulate);
        if (!simulate && extracted != 0) {
            ((MOTileEntityMachineMatter)this.machine).updateClientMatter();
        }
        return extracted;
    }

    @Override
    public int receiveMatter(int amount, boolean simulate) {
        int received = super.receiveMatter(amount, simulate);
        if (!simulate && received != 0) {
            ((MOTileEntityMachineMatter)this.machine).updateClientMatter();
        }
        return received;
    }

    @Override
    public void setMatterStored(int amount) {
        int lastMatter = super.getMatterStored();
        super.setMatterStored(amount);
        if (lastMatter != amount) {
            ((MOTileEntityMachineMatter)this.machine).updateClientMatter();
        }
    }

    @Override
    public int modifyMatterStored(int amount) {
        int modifiedAmount = super.modifyMatterStored(amount);
        if (modifiedAmount != 0) {
            ((MOTileEntityMachineMatter)this.machine).updateClientMatter();
        }
        return modifiedAmount;
    }
}

