/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.commands.MOCommand;
import matteroverdrive.commands.SubCommand;
import matteroverdrive.data.matter.DamageAwareStackHandler;
import matteroverdrive.data.matter.ItemHandler;
import matteroverdrive.data.matter.OreHandler;
import matteroverdrive.init.MatterOverdriveMatter;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class CommandMatterRegistry
extends MOCommand {
    public CommandMatterRegistry() {
        super("matterregistry");
        this.addCommand(new SubCommand("recalculate"){

            @Override
            public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
                MatterOverdrive.MATTER_REGISTRY.getItemEntires().clear();
                MatterOverdriveMatter.registerBasic(MatterOverdrive.CONFIG_HANDLER);
                MatterOverdrive.MATTER_REGISTRATION_HANDLER.runCalculationThread(sender.func_130014_f_());
            }
        });
        this.addCommand(new SubCommand("blacklist"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
                String key;
                ItemStack stack = args.length >= 3 ? CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)args[2]).func_184586_b(EnumHand.MAIN_HAND) : CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)commandSender.func_70005_c_()).func_184586_b(EnumHand.MAIN_HAND);
                if (stack.func_190926_b()) throw new CommandException("Player not holding any item", new Object[]{args[1]});
                if (args[1].equalsIgnoreCase("itemstack")) {
                    key = stack.func_77973_b().getRegistryName() + "/" + stack.func_77952_i();
                    MatterOverdrive.MATTER_REGISTRY.register(stack.func_77973_b(), new DamageAwareStackHandler(stack.func_77952_i(), 0, true));
                } else if (args[1].equalsIgnoreCase("item")) {
                    key = stack.func_77973_b().getRegistryName().toString();
                    MatterOverdrive.MATTER_REGISTRY.register(stack.func_77973_b(), new ItemHandler(0, true));
                } else {
                    if (!args[1].equalsIgnoreCase("ore")) throw new CommandException("Invalid type of item. Use either item, itemstack or ore.", new Object[0]);
                    int[] orenames = OreDictionary.getOreIDs((ItemStack)stack);
                    if (orenames == null || orenames.length <= 0) throw new CommandException("Could not find an ore dictionary entry", new Object[]{args[1]});
                    key = OreDictionary.getOreName((int)orenames[0]);
                    MatterOverdrive.MATTER_REGISTRY.registerOre(key, new OreHandler(0, true));
                }
                String[] oldBlacklist = MatterOverdrive.CONFIG_HANDLER.getStringList("matter registry", "blacklist");
                String[] newBlacklist = new String[oldBlacklist != null ? oldBlacklist.length + 1 : 1];
                newBlacklist[oldBlacklist.length] = key;
                MatterOverdrive.CONFIG_HANDLER.config.get("matter registry", "blacklist", new String[0], "").set(newBlacklist);
                MatterOverdrive.CONFIG_HANDLER.save();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "[" + key + "]" + TextFormatting.RESET + " Added $s to matter blacklist and config.\nYou must recalculate the registry for changes to take effect.\nUse /matter_registry recalculate."));
            }
        });
        this.addCommand(new SubCommand("register"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
                String key;
                int matter = CommandBase.func_175755_a((String)args[2]);
                ItemStack stack = args.length >= 4 ? CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)args[3]).func_184586_b(EnumHand.MAIN_HAND) : CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)commandSender.func_70005_c_()).func_184586_b(EnumHand.MAIN_HAND);
                if (stack.func_190926_b()) throw new CommandException("Player iz not holding any item", new Object[]{args[1]});
                if (args[1].equalsIgnoreCase("itemstack")) {
                    key = stack.func_77973_b().getRegistryName() + "/" + stack.func_77952_i();
                    MatterOverdrive.MATTER_REGISTRY.register(stack.func_77973_b(), new DamageAwareStackHandler(stack.func_77952_i(), matter));
                } else if (args[1].equalsIgnoreCase("item")) {
                    key = stack.func_77973_b().getRegistryName().toString();
                    MatterOverdrive.MATTER_REGISTRY.register(stack.func_77973_b(), new ItemHandler(matter));
                } else {
                    if (!args[1].equalsIgnoreCase("ore")) throw new CommandException("Invalid type of item. Use either item,itemstack or ore.", new Object[0]);
                    int[] oreNames = OreDictionary.getOreIDs((ItemStack)stack);
                    if (oreNames == null || oreNames.length <= 0) throw new CommandException("Could not find an ore dictionary entry!", new Object[0]);
                    key = OreDictionary.getOreName((int)oreNames[0]);
                }
                MatterOverdrive.CONFIG_HANDLER.setInt(key, "matter registry.add matter", matter);
                MatterOverdrive.CONFIG_HANDLER.save();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "[" + key + "]" + TextFormatting.RESET + " Added $s to matter registry and config.\nYou can now recalculated the registry.\nUse /matter_registry recalculate."));
            }
        });
    }
}

