/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.weapons.layers;

import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.weapons.layers.IWeaponLayer;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class WeaponLayerAmmoRender
implements IWeaponLayer {
    public static final ResourceLocation ammoBackground = new ResourceLocation("matteroverdrive:textures/gui/elements/ammo_background.png");

    @Override
    public void renderLayer(WeaponMetadataSection weaponMeta, ItemStack weapon, float ticks) {
        Vec3d modulePosition = weaponMeta.getModulePosition("ammo_holo", new Vec3d(0.17, 0.13, 0.2));
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179140_f();
        RenderUtils.disableLightmap();
        GlStateManager.func_179137_b((double)modulePosition.field_72450_a, (double)modulePosition.field_72448_b, (double)modulePosition.field_72449_c);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.002, (double)0.002, (double)0.002);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        EnergyWeapon energyWeapon = (EnergyWeapon)weapon.func_77973_b();
        float heatPerc = energyWeapon.getHeat(weapon) / energyWeapon.getMaxHeat(weapon);
        Color color = RenderUtils.lerp(Reference.COLOR_HOLO, Reference.COLOR_HOLO_RED, heatPerc);
        RenderUtils.applyColor(color);
        color = color.multiplyWithoutAlpha(0.7f);
        String ammoString = DecimalFormat.getPercentInstance().format((float)energyWeapon.getAmmo(weapon) / (float)energyWeapon.getMaxAmmo(weapon));
        int ammoStringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(ammoString);
        ClientProxy.moFontRender.func_175065_a(ammoString, (float)(16 - ammoStringWidth / 2), 9.0f, color.getColor(), false);
        GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
        ClientProxy.moFontRender.func_175065_a(DecimalFormat.getPercentInstance().format(heatPerc), 54.0f, 18.0f, color.getColor(), false);
        GlStateManager.func_179109_b((float)46.0f, (float)(28.0f - 18.0f * heatPerc), (float)0.0f);
        GlStateManager.func_179090_x();
        RenderUtils.drawPlane(4.0, 18.0f * heatPerc);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        RenderUtils.bindTexture(ammoBackground);
        RenderUtils.drawPlane(0.1, 0.05);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        RenderUtils.enableLightmap();
        RenderUtils.bindTexture(TextureMap.field_110575_b);
    }
}

