/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class StarMapRendererStars
extends StarMapRendererAbstract {
    public static Color getStarColor(Star star, EntityPlayer player) {
        return new Color(star.getColor());
    }

    protected void renderStars(Quadrant quadrant, TileEntityMachineStarMap starMap, double distanceMultiply, double starSizeMultiply) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (quadrant != null) {
            GL11.glLineWidth((float)1.0f);
            Star from = null;
            Star to = null;
            ClientProxy.renderHandler.getRenderParticlesHandler().bindSheet();
            for (Star star : quadrant.getStars()) {
                Vec3d pos = new Vec3d(star.getPosition().field_72450_a * distanceMultiply, star.getPosition().field_72448_b * distanceMultiply, star.getPosition().field_72449_c * distanceMultiply);
                this.drawStarParticle(quadrant, star, pos, (EntityPlayer)player, starMap, starSizeMultiply);
                if (starMap.getGalaxyPosition().equals(star)) {
                    from = star;
                }
                if (!starMap.getDestination().equals(star)) continue;
                to = star;
            }
            if (from != null && to != null && from != to) {
                this.drawConnection(from, to, distanceMultiply);
            }
        }
    }

    protected void drawConnection(Star from, Star to, double distanceMultiply) {
        GlStateManager.func_179090_x();
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.3f);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)((double)from.getX() * distanceMultiply), (double)((double)from.getY() * distanceMultiply), (double)((double)from.getZ() * distanceMultiply));
        GL11.glVertex3d((double)((double)to.getX() * distanceMultiply), (double)((double)to.getY() * distanceMultiply), (double)((double)to.getZ() * distanceMultiply));
        GL11.glEnd();
        GlStateManager.func_179098_w();
    }

    protected void drawStarParticle(Quadrant quadrant, Star star, Vec3d pos, EntityPlayer player, TileEntityMachineStarMap starMap, double starSizeMultiply) {
        Color color = StarMapRendererStars.getStarColor(star, player);
        double size = 0.01;
        if (starMap.getDestination().equals(star)) {
            size = 0.035;
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.selectedIcon, (double)star.getSize() * 0.05 * starSizeMultiply, pos, color);
        }
        if (starMap.getGalaxyPosition().equals(star)) {
            size = 0.035;
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.currentIcon, (double)star.getSize() * 0.05 * starSizeMultiply, pos, color);
        }
        if (star.isClaimed(player) == 3) {
            size = 0.025;
        }
        RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.star_icon, (double)star.getSize() * size * starSizeMultiply, pos, color);
    }
}

