/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import java.util.Random;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class TileEntityRendererStation<T extends MOTileEntityMachine>
extends TileEntitySpecialRenderer<T>
implements IConfigSubscriber {
    public static final ResourceLocation glowTexture = new ResourceLocation("matteroverdrive:textures/fx/hologram_beam.png");
    final Random fliker;
    protected int shaderProgram;
    protected boolean validShader = true;
    protected Color holoColor = Reference.COLOR_HOLO.multiplyWithoutAlpha(0.25f);
    protected Color red_holoColor = Reference.COLOR_HOLO_RED.multiplyWithoutAlpha(0.25f);
    private boolean enableHoloShader = true;

    public TileEntityRendererStation() {
        this.fliker = new Random();
    }

    private void drawHoloLights(TileEntity entity, World world, double x, double y, double z, double t) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        RenderUtils.disableLightmap();
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(glowTexture);
        double height = 0.5625;
        double hologramHeight = this.getLightHeight();
        double topSize = this.getLightsSize() - 1.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + height), (double)z);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.applyColor(this.getHoloColor(entity));
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(-topSize, hologramHeight, -topSize).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(1.0 + topSize, hologramHeight, -topSize).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(1.0 + topSize, hologramHeight, -topSize).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(1.0 + topSize, hologramHeight, 1.0 + topSize).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(1.0, 0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(1.0, 0.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(1.0 + topSize, hologramHeight, 1.0 + topSize).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(-topSize, hologramHeight, 1.0 + topSize).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(-topSize, hologramHeight, 1.0 + topSize).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(-topSize, hologramHeight, -topSize).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        RenderUtils.enableLightmap();
    }

    protected double getLightHeight() {
        return 1.0;
    }

    protected double getLightsSize() {
        return 1.3;
    }

    protected Color getHoloColor(TileEntity entity) {
        if (((MOTileEntityMachine)entity).func_70300_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return this.holoColor;
        }
        return this.red_holoColor;
    }

    public void render(T machine, double x, double y, double z, float ticks, int destroyStage, float a) {
        if (!((MOTileEntity)machine).shouldRender()) {
            return;
        }
        double t = MOMathHelper.noise((double)machine.func_174877_v().func_177958_n() * 0.3, (double)machine.func_174877_v().func_177956_o() * 0.3, (double)machine.func_174877_v().func_177952_p() * 0.3);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        try {
            this.renderHologram(machine, x, y, z, ticks, t);
        }
        catch (ClassCastException e) {
            MOLog.warn("Could not cast to desired station class", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            MOLog.warn("Error while render a station", e);
        }
        GlStateManager.func_179121_F();
        if (this.drawHoloLights()) {
            this.drawHoloLights((TileEntity)machine, machine.func_145831_w(), x, y, z, ticks);
        }
        GlStateManager.func_179084_k();
    }

    protected boolean drawHoloLights() {
        return true;
    }

    protected void rotate(T station, double noise) {
        GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71441_e.func_72820_D() * 0.5f + 1800.0f * (float)noise), (float)0.0f, (float)-1.0f, (float)0.0f);
    }

    protected boolean isUsable(T station) {
        return ((MOTileEntityMachine)station).func_70300_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    protected void renderHologram(T station, double x, double y, double z, float partialTicks, double noise) {
        if (!this.isUsable(station)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.8), (double)(z + 0.5));
            this.rotate(station, noise);
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Color color = Reference.COLOR_HOLO_RED.multiplyWithoutAlpha(0.33f);
            String[] info = MOStringHelper.translateToLocal("gui.hologram.access_denied", new Object[0]).split(" ");
            for (int i = 0; i < info.length; ++i) {
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(info[i]);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-width / 2), (float)-32.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(info[i], 0, i * 10, color.getColor());
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.enableHoloShader = config.getBool("use holo shader", "client", true, "Use the custom holo shader for holographic items");
    }
}

