/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import matteroverdrive.Reference;
import matteroverdrive.blocks.BlockHoloSign;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;

public class TileEntityRendererHoloSign
extends TileEntitySpecialRenderer<TileEntityHoloSign> {
    public void render(TileEntityHoloSign tile, double x, double y, double z, float ticks, int destoryStage, float a) {
        if (!tile.shouldRender()) {
            return;
        }
        EnumFacing side = (EnumFacing)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
        RenderUtils.beginDrawinngBlockScreen(x, y, z, side, Reference.COLOR_HOLO, tile, -0.8375, 0.2f);
        String text = tile.getText();
        if (text != null) {
            for (TextFormatting formatting : TextFormatting.values()) {
                text = text.replaceAll(formatting.toString().replace('\u00a7', '&'), formatting.toString());
            }
            String[] infos = text.split("\n");
            int leftMargin = 10;
            int rightMargin = 10;
            float maxSize = 4.0f;
            EnumFacing leftSide = MOBlockHelper.getLeftSide(side);
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177972_a(leftSide)).func_177230_c() instanceof BlockHoloSign) {
                leftMargin = 0;
                maxSize = 8.0f;
            }
            EnumFacing rightSide = MOBlockHelper.getRightSide(side);
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177972_a(rightSide)).func_177230_c() instanceof BlockHoloSign) {
                rightMargin = 0;
                maxSize = 8.0f;
            }
            if (tile.getConfigs().getBoolean("AutoLineSize", false)) {
                RenderUtils.drawScreenInfoWithLocalAutoSize(infos, Reference.COLOR_HOLO, side, leftMargin, rightMargin, maxSize);
            } else {
                RenderUtils.drawScreenInfoWithGlobalAutoSize(infos, Reference.COLOR_HOLO, side, leftMargin, rightMargin, maxSize);
            }
        }
        RenderUtils.endDrawinngBlockScreen();
    }
}

