/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RenderMatterScannerInfoHandler
implements IWorldLastRenderer {
    public final ResourceLocation spinnerTexture = new ResourceLocation("matteroverdrive:textures/gui/elements/spinner.png");
    private final DecimalFormat healthFormater = new DecimalFormat("#.##");

    public static void rotateFromSide(EnumFacing side, float yaw) {
        if (side == EnumFacing.UP) {
            GL11.glRotatef((float)(Math.round(yaw / 90.0f) * 90 - 180), (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (side == EnumFacing.DOWN) {
            GL11.glRotatef((float)(Math.round(yaw / 90.0f) * 90 - 180), (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (side == EnumFacing.WEST) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (side == EnumFacing.EAST) {
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (side == EnumFacing.NORTH) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (side == EnumFacing.SOUTH) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean holdingPad = false;
        EnumHand hand = EnumHand.MAIN_HAND;
        ItemStack heldItem = ItemStack.field_190927_a;
        if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            hand = EnumHand.MAIN_HAND;
            heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof IBlockScanner) {
                holdingPad = true;
            } else {
                heldItem = ItemStack.field_190927_a;
            }
        } else if (!player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
            hand = EnumHand.OFF_HAND;
            heldItem = player.func_184586_b(EnumHand.OFF_HAND);
            if (heldItem.func_77973_b() instanceof IBlockScanner) {
                holdingPad = true;
            } else {
                heldItem = ItemStack.field_190927_a;
            }
        }
        if (holdingPad && !heldItem.func_190926_b() && player.func_184600_cs() == hand) {
            GlStateManager.func_179094_E();
            this.renderInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, heldItem, event.getPartialTicks());
            GlStateManager.func_179121_F();
        } else if (MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g).isAndroid()) {
            this.renderInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71476_x, ItemStack.field_190927_a, event.getPartialTicks());
        }
    }

    private void renderInfo(EntityPlayer player, ItemStack scanner, float ticks) {
        IBlockScanner scannerItem = (IBlockScanner)scanner.func_77973_b();
        RayTraceResult position = scannerItem.getScanningPos(scanner, (EntityLivingBase)player);
        this.renderInfo(player, position, scanner, ticks);
    }

    private void renderInfo(EntityPlayer player, RayTraceResult position, ItemStack scanner, float ticks) {
        Vec3d playerPos = player.func_174824_e(ticks);
        GL11.glPushAttrib((int)16640);
        GlStateManager.func_179097_i();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179147_l();
        RenderUtils.applyColor(Reference.COLOR_HOLO);
        if (position != null) {
            if (scanner.func_77973_b() instanceof MatterScanner) {
                IBlockState blockState;
                if (position.field_72313_a == RayTraceResult.Type.BLOCK && (blockState = player.field_70170_p.func_180495_p(position.func_178782_a())).func_177230_c() != Blocks.field_150350_a) {
                    if (!MatterScanner.isLinked(scanner)) {
                        this.renderLinkInfo(position, player, playerPos, scanner);
                    } else {
                        this.renderBlockInfo(blockState, position, player, playerPos, scanner, scanner.func_190926_b());
                    }
                }
            } else if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState blockState = player.field_70170_p.func_180495_p(position.func_178782_a());
                if (blockState.func_177230_c() != Blocks.field_150350_a) {
                    this.renderBlockInfo(blockState, position, player, playerPos, scanner, scanner.func_190926_b());
                }
            } else if (position.field_72313_a == RayTraceResult.Type.ENTITY && position.field_72308_g != null) {
                this.renderEntityInfo(position.field_72308_g, position, player, playerPos, ticks);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179099_b();
    }

    private void renderLinkInfo(RayTraceResult position, EntityPlayer player, Vec3d playerPos, ItemStack scanner) {
        double offset = 0.0;
        EnumFacing side = position.field_178784_b;
        ArrayList<String> infos = new ArrayList<String>();
        infos.add("Unable to connect to");
        infos.add("Pattern Storage");
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)position.func_178782_a().func_177958_n() + 0.5 + (double)Math.abs(side.func_176730_m().func_177958_n()) * (position.field_72307_f.field_72450_a - 0.5 - (double)position.func_178782_a().func_177958_n()) - playerPos.field_72450_a), (double)((double)position.func_178782_a().func_177956_o() + 0.5 + (double)Math.abs(side.func_176730_m().func_177956_o()) * (position.field_72307_f.field_72448_b - 0.5 - (double)position.func_178782_a().func_177956_o()) - playerPos.field_72448_b + (double)player.func_70047_e()), (double)((double)position.func_178782_a().func_177952_p() + 0.5 + (double)Math.abs(side.func_176730_m().func_177952_p()) * (position.field_72307_f.field_72449_c - 0.5 - (double)position.func_178782_a().func_177952_p()) - playerPos.field_72449_c));
        RenderMatterScannerInfoHandler.rotateFromSide(side, player.field_70177_z);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(-offset));
        this.drawInfoPlane(0.0, Reference.COLOR_HOLO_RED);
        GlStateManager.func_179094_E();
        String text = "Unlinked";
        int width = this.fontRenderer().func_78256_a(text);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)-0.05);
        GlStateManager.func_179139_a((double)0.01, (double)0.01, (double)0.01);
        this.fontRenderer().func_78276_b(text, -width / 2, -40, Reference.COLOR_HOLO_RED.getColor());
        for (int i = 0; i < infos.size(); ++i) {
            width = this.fontRenderer().func_78256_a((String)infos.get(i));
            this.fontRenderer().func_78276_b((String)infos.get(i), -width / 2, -24 + 16 * i, Reference.COLOR_HOLO_RED.getColor());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockInfo(IBlockState block, RayTraceResult position, EntityPlayer player, Vec3d playerPos, ItemStack scanner, boolean infoOnly) {
        double offset = 0.0;
        EnumFacing side = position.field_178784_b;
        ArrayList<String> infos = new ArrayList<String>();
        if (block instanceof IScannable) {
            ((IScannable)block).addInfo(player.field_70170_p, position.func_178782_a().func_177958_n(), position.func_178782_a().func_177956_o(), position.func_178782_a().func_177952_p(), infos);
        } else if (player.field_70170_p.func_175625_s(position.func_178782_a()) instanceof IScannable) {
            ((IScannable)player.field_70170_p.func_175625_s(position.func_178782_a())).addInfo(player.field_70170_p, position.func_178782_a().func_177958_n(), position.func_178782_a().func_177956_o(), position.func_178782_a().func_177952_p(), infos);
        } else if (infoOnly) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)position.func_178782_a().func_177958_n() + 0.5 + (double)Math.abs(side.func_176730_m().func_177958_n()) * (position.field_72307_f.field_72450_a - 0.5 - (double)position.func_178782_a().func_177958_n()) - playerPos.field_72450_a), (double)((double)position.func_178782_a().func_177956_o() + 0.5 + (double)Math.abs(side.func_176730_m().func_177956_o()) * (position.field_72307_f.field_72448_b - 0.5 - (double)position.func_178782_a().func_177956_o()) - playerPos.field_72448_b + (double)player.func_70047_e()), (double)((double)position.func_178782_a().func_177952_p() + 0.5 + (double)Math.abs(side.func_176730_m().func_177952_p()) * (position.field_72307_f.field_72449_c - 0.5 - (double)position.func_178782_a().func_177952_p()) - playerPos.field_72449_c));
        RenderMatterScannerInfoHandler.rotateFromSide(side, player.field_70177_z);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(-offset));
        this.drawInfoPlane(0.0, Reference.COLOR_HOLO);
        ItemStack blockItemStack = block.func_177230_c().getPickBlock(block, position, player.field_70170_p, position.func_178782_a(), player);
        int matter = MatterHelper.getMatterAmountFromItem(blockItemStack);
        if (matter > 0) {
            infos.add("Matter: " + MatterHelper.formatMatter(matter));
        }
        String blockName = "Unknown";
        try {
            blockName = !blockItemStack.func_190926_b() ? blockItemStack.func_82833_r() : player.field_70170_p.func_180495_p(position.func_178782_a()).func_177230_c().func_149732_F();
        }
        catch (Exception e) {
            blockName = player.field_70170_p.func_180495_p(position.func_178782_a()).func_177230_c().func_149732_F();
        }
        finally {
            this.drawInfoList(blockName, infos);
        }
        if (!(block instanceof IScannable) && scanner != null) {
            this.drawProgressBar(scanner, player, position);
        }
        GlStateManager.func_179121_F();
    }

    private void drawProgressBar(ItemStack scanner, EntityPlayer player, RayTraceResult position) {
        ItemPattern pattern;
        IMatterDatabase database;
        GlStateManager.func_179094_E();
        this.renderer().func_110577_a(this.spinnerTexture);
        int count = player.func_184605_cv();
        int maxCount = scanner.func_77988_m();
        float ref = 1.0f - (float)count / (float)maxCount;
        Color color = Reference.COLOR_HOLO_RED;
        int i1 = Reference.COLOR_HOLO_RED.getColor();
        int i2 = Reference.COLOR_HOLO_GREEN.getColor();
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        float ratio = ref;
        float iRatio = 1.0f - ratio;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        color = new Color(a << 24 | r << 16 | g << 8 | b);
        if (ref >= 1.0f && scanner.func_77973_b() instanceof MatterScanner && (database = MatterScanner.getLink(player.field_70170_p, scanner)) != null && (pattern = database.getPattern(MatterDatabaseHelper.GetItemStackFromWorld(player.field_70170_p, position.func_178782_a()))) != null) {
            ref = 1.0f - pattern.getProgressF();
            color = pattern.getProgress() == 100 ? Reference.COLOR_HOLO : Reference.COLOR_HOLO_YELLOW;
        }
        GlStateManager.func_179092_a((int)516, (float)ref);
        RenderUtils.applyColorWithMultipy(color, 0.5f);
        RenderUtils.drawPlane(0.35, 0.45, -0.1, 0.3, 0.3);
        GlStateManager.func_179121_F();
    }

    private void renderEntityInfo(Entity entity, RayTraceResult position, EntityPlayer player, Vec3d playerPos, float ticks) {
        if (!entity.func_98034_c(player)) {
            double offset = 0.1;
            String name = entity.func_145748_c_().func_150254_d();
            ArrayList<String> infos = new ArrayList<String>();
            if (entity instanceof EntityLivingBase) {
                Vec3d entityPos = entity.func_174824_e(ticks);
                entityPos = entityPos.func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
                infos.add("Health: " + this.healthFormater.format(((EntityLivingBase)entity).func_110143_aJ()) + " / " + ((EntityLivingBase)entity).func_110138_aP());
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
                GlStateManager.func_179114_b((float)(player.field_70126_B + (player.field_70177_z - player.field_70126_B) * ticks), (float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(player.field_70127_C + (player.field_70125_A - player.field_70127_C) * ticks), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(-offset));
                this.drawInfoPlane(0.5, Reference.COLOR_HOLO);
                this.drawInfoList(name, infos);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void drawInfoPlane(double opacity, Color color) {
        if (opacity > 0.0) {
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)opacity));
            RenderUtils.drawPlane(1.0);
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179112_b((int)1, (int)769);
        RenderUtils.applyColorWithMultipy(color, 0.05f);
        this.renderer().func_110577_a(TileEntityRendererPatternMonitor.screenTextureBack);
        RenderUtils.drawPlane(0.0, 0.0, -0.01, 1.0, 1.0);
    }

    private void drawInfoList(String name, List<String> infos) {
        GlStateManager.func_179094_E();
        int width = this.fontRenderer().func_78256_a(name);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)-0.05);
        GlStateManager.func_179139_a((double)0.01, (double)0.01, (double)0.01);
        this.fontRenderer().func_78276_b(name, -width / 2, -40, Reference.COLOR_HOLO.getColor());
        for (int i = 0; i < infos.size(); ++i) {
            width = this.fontRenderer().func_78256_a(infos.get(i));
            this.fontRenderer().func_78276_b(infos.get(i), -width / 2, -24 + 16 * i, Reference.COLOR_HOLO.getColor());
        }
        GlStateManager.func_179121_F();
    }

    private FontRenderer fontRenderer() {
        return ClientProxy.moFontRender;
    }

    private TextureManager renderer() {
        return Minecraft.func_71410_x().field_71446_o;
    }
}

