/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MOModelLoader
implements ICustomModelLoader {
    private static Map<ResourceLocation, IModel> BLOCK_MODELS = Maps.newHashMap();
    private static Map<ResourceLocation, IModel> ITEM_MODELS = Maps.newHashMap();

    public boolean accepts(ResourceLocation modelLocation) {
        return BLOCK_MODELS.containsKey(modelLocation) || ITEM_MODELS.containsKey(modelLocation);
    }

    @Nonnull
    public IModel loadModel(ResourceLocation modelLocation) {
        return BLOCK_MODELS.getOrDefault(modelLocation, ITEM_MODELS.getOrDefault(modelLocation, ModelLoaderRegistry.getMissingModel()));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        BLOCK_MODELS.clear();
        ITEM_MODELS.clear();
        MinecraftForge.EVENT_BUS.post((Event)new MOModelRegistryEvent.Block(this, BLOCK_MODELS));
        MinecraftForge.EVENT_BUS.post((Event)new MOModelRegistryEvent.Item(this, ITEM_MODELS));
    }

    public static class MOModelRegistryEvent
    extends Event {
        private final MOModelLoader loader;
        private final Map<ResourceLocation, IModel> models;
        private final Type type;

        public MOModelRegistryEvent(MOModelLoader loader, Map<ResourceLocation, IModel> models, Type type) {
            this.loader = loader;
            this.models = models;
            this.type = type;
        }

        public MOModelLoader getLoader() {
            return this.loader;
        }

        public Map<ResourceLocation, IModel> getModels() {
            return ImmutableMap.copyOf(this.models);
        }

        public void register(ResourceLocation resourceLocation, IModel model) {
            this.models.put(resourceLocation, model);
        }

        public Type getType() {
            return this.type;
        }

        public static class Item
        extends MOModelRegistryEvent {
            public Item(MOModelLoader loader, Map<ResourceLocation, IModel> models) {
                super(loader, models, Type.ITEM);
            }
        }

        public static class Block
        extends MOModelRegistryEvent {
            public Block(MOModelLoader loader, Map<ResourceLocation, IModel> models) {
                super(loader, models, Type.BLOCK);
            }
        }

        public static enum Type {
            BLOCK,
            ITEM;

        }
    }
}

