/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.wrench.IWrenchable;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.machines.dimensional_pylon.TileEntityMachineDimensionalPylon;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class BlockPylon
extends MOBlockContainer<TileEntityMachineDimensionalPylon>
implements IWrenchable {
    public static final PropertyEnum<MultiblockType> TYPE = PropertyEnum.func_177709_a((String)"type", MultiblockType.class);
    public static final PropertyBool CTM = PropertyBool.func_177716_a((String)"ctm");

    public BlockPylon(Material material, String name) {
        super(material, name);
        this.func_149711_c(8.0f);
        this.func_149713_g(0);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(MatterOverdrive.TAB_OVERDRIVE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CTM, (Comparable)Boolean.valueOf(Loader.isModLoaded((String)"ctm") && state.func_177229_b(TYPE) == MultiblockType.MAIN));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, CTM});
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)MultiblockType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        MultiblockType type = (MultiblockType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public Class<TileEntityMachineDimensionalPylon> getTileEntityClass() {
        return TileEntityMachineDimensionalPylon.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityMachineDimensionalPylon();
    }

    @Override
    public boolean onWrenchHit(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity pylon = world.func_175625_s(pos);
        if (pylon != null && pylon instanceof TileEntityMachineDimensionalPylon) {
            return ((TileEntityMachineDimensionalPylon)pylon).onWrenchHit(stack, player, world, pos, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMachineDimensionalPylon) {
            return ((TileEntityMachineDimensionalPylon)tileEntity).openMultiBlockGui(worldIn, playerIn);
        }
        return false;
    }

    @Deprecated
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState originalBlockState = world.func_180495_p(pos.func_177972_a(side.func_176734_d()));
        if (originalBlockState.func_177230_c() == this && originalBlockState.func_177229_b(TYPE) == MultiblockType.DUMMY) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return state.func_177229_b(TYPE) == MultiblockType.DUMMY ? EnumBlockRenderType.INVISIBLE : super.func_149645_b(state);
    }

    public static enum MultiblockType implements IStringSerializable
    {
        NORMAL("normal"),
        DUMMY("dummy"),
        MAIN("main");

        private final String name;

        private MultiblockType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

