/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.network;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class MatterNetworkTask {
    long id;
    String name;
    String unlocalizedName;
    MatterNetworkTaskState state = MatterNetworkTaskState.UNKNOWN;

    public MatterNetworkTask() {
        this.init();
    }

    protected void init() {
        this.id = UUID.randomUUID().getMostSignificantBits();
    }

    public boolean isValid(World world) {
        return true;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound != null) {
            this.state = MatterNetworkTaskState.get(compound.func_74762_e("State"));
            this.id = compound.func_74763_f("id");
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (compound != null) {
            compound.func_74768_a("State", this.state.ordinal());
            compound.func_74772_a("id", this.id);
        }
    }

    public void addInfo(List<String> list) {
        list.add(this.getColorForState(this.state) + "[ " + MOStringHelper.translateToLocal("task.state." + (Object)((Object)this.getState()) + ".name", new Object[0]) + " ]");
        String unlocalizedDescription = "task." + this.getUnlocalizedName() + ".state." + (Object)((Object)this.state) + ".description";
        String[] infos = MOStringHelper.hasTranslation(unlocalizedDescription) ? MOStringHelper.translateToLocal(unlocalizedDescription, new Object[0]).split("\n") : MOStringHelper.translateToLocal("task.state." + (Object)((Object)this.state) + ".description", new Object[0]).split("\n");
        Collections.addAll(list, infos);
    }

    private TextFormatting getColorForState(MatterNetworkTaskState state) {
        switch (state) {
            case WAITING: {
                return TextFormatting.AQUA;
            }
            case QUEUED: {
                return TextFormatting.BLUE;
            }
            case PROCESSING: {
                return TextFormatting.YELLOW;
            }
            case FINISHED: {
                return TextFormatting.GREEN;
            }
        }
        return TextFormatting.GRAY;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public void setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public long getId() {
        return this.id;
    }

    public MatterNetworkTaskState getState() {
        return this.state;
    }

    public void setState(MatterNetworkTaskState state) {
        this.state = state;
    }
}

