/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.gravity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class AnomalySuppressor {
    private BlockPos pos;
    private int time;
    private float amount;

    public AnomalySuppressor(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public AnomalySuppressor(BlockPos pos, int time, float amount) {
        this.pos = pos;
        this.time = time;
        this.amount = amount;
    }

    public boolean update(AnomalySuppressor suppressor) {
        if (suppressor.pos.equals((Object)this.pos)) {
            if (this.time < suppressor.time) {
                this.time = suppressor.time;
            }
            this.amount = suppressor.amount;
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74772_a("block", this.pos.func_177986_g());
        tagCompound.func_74774_a("time", (byte)this.time);
        tagCompound.func_74776_a("amount", this.amount);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.pos = BlockPos.func_177969_a((long)tagCompound.func_74763_f("block"));
        this.time = tagCompound.func_74771_c("time");
        this.amount = tagCompound.func_74760_g("amount");
    }

    public void tick() {
        --this.time;
    }

    public boolean isValid() {
        return this.time > 0;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }
}

