/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import matteroverdrive.Constant;
import net.minecraft.util.ResourceLocation;

public class RecipeExporter {
    public static String template = "\t$output: [\n\t\t[\n\t\t\t$content\n\t\t]\n\t],";
    public static String shapeless = "    $output: [\n        [$content]\n    ],";

    public static void main(String[] arr) throws FileNotFoundException {
        String result;
        JsonElement a;
        JsonElement m;
        String v;
        JsonObject res;
        String type;
        JsonObject obj;
        ResourceLocation reg;
        Gson gson = new Gson();
        Constant[] constants = (Constant[])gson.fromJson((Reader)new FileReader(new File("../src/main/resources/assets/matteroverdrive/recipes/_constants.json")), Constant[].class);
        final HashMap con = new HashMap();
        Stream.of(constants).forEach(cons -> con.put(cons.name, cons.ingredient));
        for (File file : new File("../src/main/resources/assets/matteroverdrive/recipes").listFiles()) {
            reg = new ResourceLocation("matteroverdrive", file.getName().replace(".json", ""));
            if (reg.func_110623_a().equals("_constants") || !file.getName().endsWith("json")) continue;
            obj = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            type = obj.get("type").getAsString();
            res = obj.get("result").getAsJsonObject();
            v = res.get("item").getAsString();
            m = res.get("data");
            if (m != null) {
                v = v + ":" + m.getAsInt();
            }
            if ((a = res.get("count")) != null) {
                v = v + " * " + a.getAsInt();
            }
            result = "<" + v + ">";
            if (!type.equals("minecraft:crafting_shaped")) continue;
            final HashMap itemMap = new HashMap();
            obj.get("key").getAsJsonObject().entrySet().forEach(new Consumer<Map.Entry<String, JsonElement>>(){

                @Override
                public void accept(Map.Entry<String, JsonElement> stringJsonElementEntry) {
                    String s = stringJsonElementEntry.getKey();
                    JsonObject jsonObject = stringJsonElementEntry.getValue().getAsJsonObject();
                    String item = jsonObject.get("item").getAsString();
                    if (item.startsWith("#")) {
                        Constant.Ingredient ing = (Constant.Ingredient)con.get(item.substring(1));
                        itemMap.put(s, "<ore:" + ing.ore + ">");
                    } else {
                        String var = item;
                        JsonElement data = jsonObject.get("data");
                        if (data != null) {
                            var = var + ":" + data.getAsInt();
                        }
                        itemMap.put(s, "<" + var + ">");
                    }
                }
            });
            AtomicReference<String> s = new AtomicReference<String>(template.replace("$output", result));
            StringBuilder content = new StringBuilder();
            int[] i = new int[]{0, 1};
            obj.get("pattern").getAsJsonArray().forEach(element -> {
                StringBuilder row = new StringBuilder();
                Stream.of(element.getAsString().split("")).forEach(str -> {
                    if (str.equals(" ")) {
                        if (row.toString().isEmpty()) {
                            row.append("null");
                        } else {
                            row.append(", null");
                        }
                    } else if (row.toString().isEmpty()) {
                        row.append((String)itemMap.get(str));
                    } else {
                        row.append(", ").append((String)itemMap.get(str));
                    }
                    i[1] = i[1] + 1;
                });
                if (content.toString().isEmpty()) {
                    content.append("[").append(row.toString()).append("]");
                } else {
                    content.append(",\n\t\t\t").append("[").append(row.toString()).append("]");
                }
                i[0] = i[0] + 1;
                i[1] = 1;
            });
            System.out.println(s.get().replace("$content", content.toString()));
        }
        for (File file : new File("../src/main/resources/assets/matteroverdrive/recipes").listFiles()) {
            reg = new ResourceLocation("matteroverdrive", file.getName().replace(".json", ""));
            if (reg.func_110623_a().equals("_constants") || !file.getName().endsWith("json")) continue;
            obj = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            type = obj.get("type").getAsString();
            res = obj.get("result").getAsJsonObject();
            v = res.get("item").getAsString();
            m = res.get("data");
            if (m != null) {
                v = v + ":" + m.getAsInt();
            }
            if ((a = res.get("count")) != null) {
                v = v + " * " + a.getAsInt();
            }
            result = "<" + v + ">";
            if (!type.equals("minecraft:crafting_shapeless")) continue;
            AtomicReference<String> content = new AtomicReference<String>("");
            obj.get("ingredients").getAsJsonArray().forEach(element -> {
                JsonObject jsonObject = element.getAsJsonObject();
                String item = jsonObject.get("item").getAsString();
                if (item.startsWith("#")) {
                    Constant.Ingredient ing = (Constant.Ingredient)con.get(item.substring(1));
                    if (((String)content.get()).isEmpty()) {
                        content.set((String)content.get() + "<ore:" + ing.ore + ">");
                    } else {
                        content.set((String)content.get() + ", <ore:" + ing.ore + ">");
                    }
                } else {
                    String var = item;
                    JsonElement data = jsonObject.get("data");
                    if (data != null) {
                        var = var + ":" + data.getAsInt();
                    }
                    if (((String)content.get()).isEmpty()) {
                        content.set((String)content.get() + "<" + var + ">");
                    } else {
                        content.set((String)content.get() + ", <" + var + ">");
                    }
                }
            });
            System.out.println(shapeless.replace("$output", result).replace("$content", content.get()));
        }
    }
}

