/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.permissions;

import com.mumfrey.liteloader.permissions.Permission;
import com.mumfrey.liteloader.permissions.ReplicatedPermissions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.eq2online.permissions.ReplicatedPermissionsContainer;

public class ServerPermissions
implements ReplicatedPermissions {
    private static final Pattern permissionPattern = Pattern.compile("^([\\+\\-])(([a-z0-9]+\\.)*[a-z0-9\\*]+)$", 2);
    protected String modName;
    protected Permission permissions = new Permission();
    protected long createdTime = System.currentTimeMillis();
    protected long validUntil = this.createdTime + this.cacheTime;
    protected long cacheTime = 600000L;
    protected long refreshTime = 15000L;

    public ServerPermissions(byte[] data) {
        ReplicatedPermissionsContainer response = ReplicatedPermissionsContainer.fromBytes(data);
        if (response != null) {
            response.sanitise();
            this.modName = response.modName;
            this.validUntil = System.currentTimeMillis() + response.remoteCacheTimeSeconds * 1000L;
            for (String permissionString : response.permissions) {
                Matcher permissionMatcher = permissionPattern.matcher(permissionString);
                if (!permissionMatcher.matches()) continue;
                String name = permissionMatcher.group(2);
                boolean value = permissionMatcher.group(1).equals("+");
                this.permissions.setPermissionAndValue(name, value);
            }
        }
    }

    public String getModName() {
        return this.modName;
    }

    @Override
    public boolean getPermissionSet(String permission) {
        return this.permissions.getPermission(permission) != null;
    }

    @Override
    public boolean getHasPermission(String permission) {
        Permission perm = this.permissions.getPermission(permission);
        return perm != null && perm.getValue();
    }

    @Override
    public boolean getHasPermission(String permission, boolean defaultValue) {
        Permission perm = this.permissions.getPermission(permission);
        return perm != null ? perm.getValue() : defaultValue;
    }

    @Override
    public long getReplicationTime() {
        return this.createdTime;
    }

    @Override
    public boolean isValid() {
        return System.currentTimeMillis() < this.validUntil;
    }

    @Override
    public void invalidate() {
        this.validUntil = 0L;
    }

    @Override
    public void notifyRefreshPending() {
        this.validUntil = System.currentTimeMillis() + this.refreshTime;
    }
}

