/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.EnumeratorModuleClassPath;
import com.mumfrey.liteloader.core.api.EnumeratorModuleFolder;
import com.mumfrey.liteloader.interfaces.ObjectFactory;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LiteLoaderCoreAPI
implements LiteAPI {
    protected static final String PKG_LITELOADER = "com.mumfrey.liteloader";
    protected static final String PKG_LITELOADER_COMMON = "com.mumfrey.liteloader.common";
    protected LoaderEnvironment environment;
    protected LoaderProperties properties;
    protected boolean searchClassPath;
    protected boolean searchProtectionDomain;
    protected boolean searchModsFolder;

    @Override
    public String getIdentifier() {
        return "liteloader";
    }

    @Override
    public String getName() {
        return "LiteLoader core API";
    }

    @Override
    public String getVersion() {
        return LiteLoaderVersion.CURRENT.getLoaderVersion();
    }

    @Override
    public int getRevision() {
        return LiteLoaderVersion.CURRENT.getLoaderRevision();
    }

    @Override
    public String getModClassPrefix() {
        return "LiteMod";
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }

    void readDiscoverySettings() {
        this.searchModsFolder = this.properties.getAndStoreBooleanProperty("search.mods", true);
        this.searchProtectionDomain = this.properties.getAndStoreBooleanProperty("search.jar", false);
        this.searchClassPath = this.properties.getAndStoreBooleanProperty("search.classpath", true);
        if (!(this.searchModsFolder || this.searchProtectionDomain || this.searchClassPath)) {
            LiteLoaderLogger.warning("Invalid configuration, no search locations defined. Enabling all search locations.", new Object[0]);
            this.searchModsFolder = true;
            this.searchClassPath = true;
        }
    }

    void writeDiscoverySettings() {
        this.properties.setBooleanProperty("search.mods", this.searchModsFolder);
        this.properties.setBooleanProperty("search.jar", this.searchProtectionDomain);
        this.properties.setBooleanProperty("search.classpath", this.searchClassPath);
    }

    @Override
    public List<EnumeratorModule> getEnumeratorModules() {
        this.readDiscoverySettings();
        ArrayList<EnumeratorModule> enumeratorModules = new ArrayList<EnumeratorModule>();
        if (this.searchClassPath) {
            enumeratorModules.add(new EnumeratorModuleClassPath());
        }
        if (this.searchProtectionDomain) {
            LiteLoaderLogger.warning("Protection domain searching is no longer required or supported, protection domain search has been disabled", new Object[0]);
            this.searchProtectionDomain = false;
        }
        if (this.searchModsFolder) {
            File modsFolder = this.environment.getModsFolder();
            enumeratorModules.add(new EnumeratorModuleFolder(this, modsFolder, true));
            File versionedModsFolder = this.environment.getVersionedModsFolder();
            enumeratorModules.add(new EnumeratorModuleFolder(this, versionedModsFolder, false));
        }
        return Collections.unmodifiableList(enumeratorModules);
    }

    public abstract ObjectFactory<?, ?> getObjectFactory();
}

