/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.LinkedList;

public abstract class ClientPluginChannels
extends PluginChannels<PluginChannelListener> {
    private static ClientPluginChannels instance;

    protected ClientPluginChannels() {
        if (instance != null) {
            throw new RuntimeException("Plugin Channels Startup Error", new InstantiationException("Only a single instance of ClientPluginChannels is allowed"));
        }
        instance = this;
    }

    @Override
    protected FastIterableDeque<PluginChannelListener> createHandlerList() {
        return new HandlerList<PluginChannelListener>(PluginChannelListener.class);
    }

    protected static ClientPluginChannels getInstance() {
        return instance;
    }

    @Override
    public void initProvider() {
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(PluginChannelListener.class);
    }

    void addClientPluginChannelListener(PluginChannelListener pluginChannelListener) {
        super.addPluginChannelListener(pluginChannelListener);
    }

    public abstract void onPluginChannelMessage(gr var1);

    protected void onPluginChannelMessage(String channel, byte[] data) {
        if ("REGISTER".equals(channel)) {
            this.onRegisterPacketReceived(data);
        } else if (this.pluginChannels.containsKey(channel)) {
            try {
                PermissionsManagerClient permissionsManager = LiteLoader.getClientPermissionsManager();
                if (permissionsManager != null) {
                    permissionsManager.onCustomPayload(channel, data.length, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onModPacketReceived(channel, data, data.length);
        }
    }

    protected void onModPacketReceived(String channel, byte[] data, int length) {
        for (PluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(channel, length, data);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(fb netHandler) {
        this.addPluginChannelsFor(LiteLoader.getClientPermissionsManager());
        try {
            for (PluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
                this.addPluginChannelsFor(pluginChannelListener);
            }
            byte[] registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(netHandler, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to server %s", ex.getClass().getSimpleName());
        }
    }

    protected abstract void sendRegistrationData(fb var1, byte[] var2);

    public static boolean sendMessage(String channel, byte[] data, PluginChannels.ChannelPolicy policy) {
        if (instance != null) {
            return instance.send(channel, data, policy);
        }
        return false;
    }

    protected abstract boolean send(String var1, byte[] var2, PluginChannels.ChannelPolicy var3);
}

