/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.forge.mixin;

import me.shedaniel.lightoverlay.common.forge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class MixinClientConnection {
    @Inject(method={"genericsFtw"}, at={@At(value="HEAD")})
    private static void handlePacket(Packet packet, PacketListener listener, CallbackInfo ci) {
        try {
            if (!(listener instanceof ClientPacketListener)) {
                return;
            }
            ClientPacketListener packetListener = (ClientPacketListener)listener;
            ClientLevel level = packetListener.m_105147_();
            if (level == null) {
                return;
            }
            if (packet instanceof ClientboundBlockUpdatePacket) {
                ClientboundBlockUpdatePacket p = (ClientboundBlockUpdatePacket)packet;
                LightOverlay.queueChunkAndNear(new CubicChunkPos(p.m_131749_()));
            } else if (packet instanceof ClientboundSetChunkCacheCenterPacket) {
                int start;
                ClientboundSetChunkCacheCenterPacket p = (ClientboundSetChunkCacheCenterPacket)packet;
                int height = Mth.m_14165_((double)((double)level.m_141928_() / 32.0));
                for (int y = start = Math.floorDiv(level.m_141937_(), 32); y < start + height; ++y) {
                    LightOverlay.queueChunkAndNear(new CubicChunkPos(p.m_133094_(), y, p.m_133097_()));
                }
            } else if (packet instanceof ClientboundSectionBlocksUpdatePacket) {
                ClientboundSectionBlocksUpdatePacket p = (ClientboundSectionBlocksUpdatePacket)packet;
                LightOverlay.queueChunkAndNear(new CubicChunkPos(p.f_132980_.m_123341_(), p.f_132980_.m_123342_() >> 1, p.f_132980_.m_123343_()));
            } else if (packet instanceof ClientboundLightUpdatePacket) {
                int start;
                ClientboundLightUpdatePacket p = (ClientboundLightUpdatePacket)packet;
                int height = Mth.m_14165_((double)((double)level.m_141928_() / 32.0));
                for (int y = start = Math.floorDiv(level.m_141937_(), 32); y < start + height; ++y) {
                    LightOverlay.queueChunk(new CubicChunkPos(p.m_132349_(), y, p.m_132352_()));
                }
            }
        }
        catch (Throwable throwable) {
            new RuntimeException("Light Overlay failed to process packet", throwable).printStackTrace();
        }
    }
}

