/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.gui.ingredients.RecipeSlot;
import mezz.jei.gui.ingredients.RecipeSlotsView;

public class RecipeSlots {
    private final List<RecipeSlot> slots = new ArrayList<RecipeSlot>();
    private final IRecipeSlotsView view = new RecipeSlotsView(this.slots);

    public IRecipeSlotsView getView() {
        return this.view;
    }

    public List<RecipeSlot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public void addSlot(RecipeSlot slot) {
        this.slots.add(slot);
    }

    public void draw(PoseStack poseStack, int highlightColor, int recipeMouseX, int recipeMouseY) {
        for (RecipeSlot slot : this.slots) {
            slot.draw(poseStack);
            if (!slot.isMouseOver(recipeMouseX, recipeMouseY)) continue;
            slot.drawHighlight(poseStack, highlightColor);
        }
    }

    public Optional<RecipeSlot> getHoveredSlot(double recipeMouseX, double recipeMouseY) {
        return this.slots.stream().filter(ingredient -> ingredient.isMouseOver(recipeMouseX, recipeMouseY)).findFirst();
    }
}

