/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import mezz.jei.Internal;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IngredientSortStage;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static IClientConfig instance;
    private static final int minRecipeGuiHeight = 175;
    private static final int defaultRecipeGuiHeight = 350;
    private static final GiveMode defaultGiveMode;
    private static final boolean defaultCenterSearchBar = false;
    public static final List<IngredientSortStage> ingredientSorterStagesDefault;
    private List<IngredientSortStage> ingredientSorterStages = ingredientSorterStagesDefault;
    private final ForgeConfigSpec.BooleanValue debugModeEnabled;
    private final ForgeConfigSpec.BooleanValue centerSearchBarEnabled;
    private final ForgeConfigSpec.BooleanValue lowMemorySlowSearchEnabled;
    private final ForgeConfigSpec.BooleanValue cheatToHotbarUsingHotkeysEnabled;
    private final ForgeConfigSpec.EnumValue<GiveMode> giveMode;
    private final ForgeConfigSpec.IntValue maxRecipeGuiHeight;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> searchColorsCfg;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> ingredientSorterStagesCfg;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        instance = this;
        builder.push("advanced");
        builder.comment("Debug mode enabled");
        this.debugModeEnabled = builder.define("DebugMode", false);
        builder.comment("Display search bar in the center");
        this.centerSearchBarEnabled = builder.define("CenterSearch", false);
        builder.comment("Set low-memory mode (makes search very slow, but uses less RAM)");
        this.lowMemorySlowSearchEnabled = builder.define("LowMemorySlowSearchEnabled", false);
        builder.comment("Enable cheating items into the hotbar by using the shift+number keys.");
        this.cheatToHotbarUsingHotkeysEnabled = builder.define("CheatToHotbarUsingHotkeysEnabled", false);
        builder.comment("How items should be handed to you");
        this.giveMode = builder.defineEnum("GiveMode", (Enum)defaultGiveMode);
        builder.comment("Max. recipe gui height");
        this.maxRecipeGuiHeight = builder.defineInRange("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE);
        builder.pop();
        builder.push("colors");
        builder.comment("Color values to search for");
        this.searchColorsCfg = builder.defineList("SearchColors", (List)Lists.newArrayList((Object[])ColorGetter.getColorDefaults()), ClientConfig::validSearchColor);
        builder.pop();
        builder.push("sorting");
        builder.comment(String.format("Sorting order for the ingredient list. Valid stages: %s", List.of(IngredientSortStage.values())));
        List<String> defaults = ingredientSorterStagesDefault.stream().map(Enum::name).toList();
        Predicate<Object> elementValidator = ClientConfig.validEnumElement(IngredientSortStage.class);
        this.ingredientSorterStagesCfg = builder.defineList("IngredientSortStages", defaults, elementValidator);
        builder.pop();
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    public void reload() {
        this.ingredientSorterStages = ((List)this.ingredientSorterStagesCfg.get()).stream().map(s -> (IngredientSortStage)EnumUtils.getEnum(IngredientSortStage.class, (String)s)).filter(Objects::nonNull).toList();
        if (this.ingredientSorterStages.isEmpty()) {
            this.ingredientSorterStages = ingredientSorterStagesDefault;
        }
        this.syncSearchColorsConfig();
    }

    @Override
    public boolean isDebugModeEnabled() {
        return (Boolean)this.debugModeEnabled.get();
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return (Boolean)this.centerSearchBarEnabled.get();
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return (Boolean)this.lowMemorySlowSearchEnabled.get();
    }

    @Override
    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return (Boolean)this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    @Override
    public GiveMode getGiveMode() {
        return (GiveMode)((Object)this.giveMode.get());
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return (Integer)this.maxRecipeGuiHeight.get();
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages;
    }

    private void syncSearchColorsConfig() {
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        List searchColors = (List)this.searchColorsCfg.get();
        for (String entry : searchColors) {
            try {
                Map.Entry<Integer, String> result = ClientConfig.parseSearchColor(entry);
                if (result == null) {
                    LOGGER.error("Invalid number format for searchColor entry: {}", (Object)entry);
                    continue;
                }
                searchColorsMapBuilder.put(result);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid number format for searchColor entry: {}", (Object)entry, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Integer, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
    }

    private static Predicate<Object> validEnumElement(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] enumConstants;
        HashSet<String> validEntries = new HashSet<String>();
        for (Enum<?> enumConstant : enumConstants = enumClass.getEnumConstants()) {
            String name = enumConstant.name();
            validEntries.add(name);
        }
        return obj -> {
            if (obj instanceof String) {
                String name = (String)obj;
                return validEntries.contains(name);
            }
            return false;
        };
    }

    @Nullable
    private static Map.Entry<Integer, String> parseSearchColor(Object obj) throws NumberFormatException {
        String entry;
        String[] values;
        if (obj instanceof String && (values = (entry = (String)obj).split(":")).length == 2) {
            String name = values[0];
            Integer color = Integer.decode("0x" + values[1]);
            return new ColorEntry(color, name);
        }
        return null;
    }

    private static boolean validSearchColor(Object obj) {
        try {
            Map.Entry<Integer, String> result = ClientConfig.parseSearchColor(obj);
            return result != null;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    static {
        defaultGiveMode = GiveMode.MOUSE_PICKUP;
        ingredientSorterStagesDefault = List.of(IngredientSortStage.MOD_NAME, IngredientSortStage.INGREDIENT_TYPE, IngredientSortStage.CREATIVE_MENU);
    }

    private static class ColorEntry
    implements Map.Entry<Integer, String> {
        private final Integer color;
        private final String name;

        public ColorEntry(Integer color, String name) {
            this.color = color;
            this.name = name;
        }

        @Override
        public Integer getKey() {
            return this.color;
        }

        @Override
        public String getValue() {
            return this.name;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

