/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod;

import java.util.Arrays;
import java.util.List;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.CarpentersBlocks;
import journeymap.client.model.mod.Miscellaneous;
import journeymap.client.model.mod.TerraFirmaCraft;
import journeymap.client.model.mod.vanilla.VanillaBlockHandler;
import journeymap.common.Journeymap;
import org.apache.logging.log4j.Logger;

public class ModBlockDelegate {
    private static Logger logger = Journeymap.getLogger();
    private final List<IModBlockHandler> handlers = Arrays.asList(new VanillaBlockHandler(), new CarpentersBlocks.CommonHandler(), new TerraFirmaCraft.TfcBlockHandler(), new Miscellaneous.CommonHandler());

    public static BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
        BlockMD delegatedBlockMD = null;
        try {
            IModBlockHandler handler = blockMD.getModBlockHandler();
            if (handler != null) {
                delegatedBlockMD = handler.handleBlock(chunkMD, blockMD, localX, y, localZ);
            } else {
                blockMD.setModBlockHandler(null);
            }
        }
        catch (Throwable t) {
            String message = String.format("Error handling block '%s': %s", blockMD, LogFormatter.toString(t));
            logger.error(message);
        }
        if (delegatedBlockMD == null) {
            delegatedBlockMD = blockMD;
        }
        return delegatedBlockMD;
    }

    public void initialize(BlockMD blockMD) {
        for (IModBlockHandler handler : this.handlers) {
            this.initialize(handler, blockMD);
        }
    }

    private void initialize(IModBlockHandler handler, BlockMD blockMD) {
        try {
            boolean specialHandling = handler.initialize(blockMD);
            if (specialHandling) {
                logger.info(String.format("Registered IModBlockHandler %s for: '%s'.", handler.getClass().getName(), blockMD));
            }
        }
        catch (Throwable t) {
            String message = String.format("Couldn't initialize IModBlockHandler '%s': %s", handler.getClass(), LogFormatter.toString(t));
            logger.error(message);
            return;
        }
    }

    public static interface IModBlockColorHandler {
        public Integer getBlockColor(ChunkMD var1, BlockMD var2, int var3, int var4, int var5);

        public Integer getTextureColor(BlockMD var1);
    }

    public static interface IModBlockHandler {
        public boolean initialize(BlockMD var1);

        public BlockMD handleBlock(ChunkMD var1, BlockMD var2, int var3, int var4, int var5);
    }
}

