/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility.inventory;

import com.infinityraider.infinitylib.utility.inventory.IInventoryWrapped;
import com.infinityraider.infinitylib.utility.inventory.IItemHandlerWrapped;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public interface IInventoryItemHandler
extends IInventoryWrapped,
IItemHandlerWrapped {
    @Override
    @Nonnull
    default public ItemStack func_70301_a(int index) {
        return IItemHandlerWrapped.super.getStackInSlot(index);
    }

    default public int getSlots() {
        return this.func_70302_i_();
    }

    default public int getSlotLimit(int slot) {
        return this.func_70297_j_();
    }

    @Nonnull
    default public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isValidSlot(slot) || stack.func_190926_b() || stack.func_190916_E() <= 0) {
            return stack;
        }
        ItemStack inSlot = this.func_70301_a(slot);
        if (inSlot.func_190926_b() || inSlot.func_190916_E() <= 0) {
            if (!simulate) {
                this.func_70299_a(slot, stack.func_77946_l());
            }
            return ItemStack.field_190927_a;
        }
        if (ItemStack.func_179545_c((ItemStack)inSlot, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)stack)) {
            int max = stack.func_77973_b().getItemStackLimit(stack);
            int transfer = Math.min(stack.func_190916_E(), max - inSlot.func_190916_E());
            if (!simulate) {
                inSlot.func_190920_e(inSlot.func_190916_E() + transfer);
                this.func_70299_a(slot, inSlot);
            }
            if (transfer >= stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            stack.func_190920_e(stack.func_190916_E() - transfer);
            return stack;
        }
        return stack;
    }

    @Nonnull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.isValidSlot(slot) || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack inSlot = this.func_70301_a(slot);
        if (inSlot.func_190926_b() || inSlot.func_190916_E() < 0) {
            return ItemStack.field_190927_a;
        }
        amount = Math.min(amount, inSlot.func_77973_b().getItemStackLimit(inSlot));
        ItemStack stack = inSlot.func_77946_l();
        if (amount >= inSlot.func_190916_E()) {
            if (!simulate) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return stack;
        }
        stack.func_190920_e(amount);
        if (!simulate) {
            inSlot.func_190920_e(inSlot.func_190916_E() - amount);
            this.func_70299_a(slot, inSlot);
        }
        return stack;
    }

    default public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    default public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.func_94041_b(slot, stack);
    }

    default public boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.getSlots();
    }
}

