/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class WorldHelper {
    public static <T> Optional<T> getBlock(IBlockReader world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_180495_p(pos)).map(AbstractBlock.AbstractBlockState::func_177230_c).filter(b -> type.isAssignableFrom(b.getClass())).map(type::cast);
    }

    public static <T> Optional<T> getTile(IBlockReader world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_175625_s(pos)).filter(te -> type.isAssignableFrom(te.getClass())).map(type::cast);
    }

    public static <T> Optional<T> getCapability(IBlockReader world, BlockPos pos, Capability<T> capability, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_175625_s(pos)).flatMap(tile -> {
            if (type.isAssignableFrom(tile.getClass())) {
                return Optional.of(type.cast(tile));
            }
            return tile.getCapability(capability).map(obj -> obj);
        });
    }

    public static <T> List<T> collectBlocks(IBlockReader world, BlockPos min, BlockPos max, Class<T> type) {
        return WorldHelper.streamBlocks(world, min, max, type).collect(Collectors.toList());
    }

    public static <T> List<T> collectTiles(IBlockReader world, BlockPos min, BlockPos max, Class<T> type) {
        return WorldHelper.streamTiles(world, min, max, type).collect(Collectors.toList());
    }

    public static <T> List<T> collectCapabilities(IBlockReader world, BlockPos min, BlockPos max, Capability<T> capability, Class<T> type) {
        return WorldHelper.streamCapabilities(world, min, max, capability, type).collect(Collectors.toList());
    }

    public static <T> Stream<T> streamBlocks(IBlockReader world, BlockPos min, BlockPos max, Class<T> type) {
        return WorldHelper.streamRange(world, min, max, (w, pos) -> WorldHelper.getBlock(w, pos, type));
    }

    public static <T> Stream<T> streamTiles(IBlockReader world, BlockPos min, BlockPos max, Class<T> type) {
        return WorldHelper.streamRange(world, min, max, (w, pos) -> WorldHelper.getTile(w, pos, type));
    }

    public static <T> Stream<T> streamCapabilities(IBlockReader world, BlockPos min, BlockPos max, Capability<T> capability, Class<T> type) {
        return WorldHelper.streamRange(world, min, max, (w, pos) -> WorldHelper.getCapability(w, pos, capability, type));
    }

    public static <T> Stream<T> streamRange(IBlockReader world, BlockPos min, BlockPos max, BiFunction<IBlockReader, BlockPos, Optional<T>> getter) {
        return WorldHelper.streamPositions(min, max).map(pos -> (Optional)getter.apply(world, (BlockPos)pos)).filter(Optional::isPresent).map(Optional::get);
    }

    public static Stream<BlockPos> streamPositions(BlockPos min, BlockPos max) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(0, 0, 0);
        return IntStream.rangeClosed(min.func_177958_n(), max.func_177958_n()).mapToObj(x -> IntStream.rangeClosed(min.func_177956_o(), max.func_177956_o()).mapToObj(y -> IntStream.rangeClosed(min.func_177952_p(), max.func_177952_p()).mapToObj(z -> {
            mutable.func_181079_c(x, y, z);
            return mutable;
        })).flatMap(stream -> stream)).flatMap(stream -> stream);
    }

    public static <T> List<T> getTileNeighbors(IBlockReader world, BlockPos pos, Class<T> type) {
        return WorldHelper.getTileNeighbors(world, pos, type, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
    }

    public static <T> List<T> getTileNeighbors(IBlockReader world, BlockPos pos, Class<T> type, Direction ... dirs) {
        ArrayList<T> neighbours = new ArrayList<T>();
        for (Direction dir : dirs) {
            TileEntity te = world.func_175625_s(pos.func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()));
            if (te == null || !type.isAssignableFrom(te.getClass())) continue;
            neighbours.add(type.cast(te));
        }
        return neighbours;
    }

    public static void spawnItemInWorld(IBlockReader world, BlockPos pos, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            WorldHelper.spawnItemInWorld(world, pos, stack);
        }
    }

    public static void spawnItemInWorld(IBlockReader world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            WorldHelper.spawnItemInWorld(world, pos, stack);
        }
    }

    public static void spawnItemInWorld(World world, BlockPos pos, ItemStack stack) {
        if (world != null && pos != null && stack != null && stack.func_77973_b() != null) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        } else {
            StringBuilder sb = new StringBuilder();
            Optional<World> optWorld = Optional.ofNullable(world);
            Optional<BlockPos> optPos = Optional.ofNullable(pos);
            Optional<ItemStack> optStack = Optional.ofNullable(stack);
            sb.append("\n");
            sb.append("==================================================\n");
            sb.append("InfinityLib Warning!\n");
            sb.append("==================================================\n");
            sb.append("\n");
            sb.append("Cause:\n");
            sb.append("--------------------------------------------------\n");
            sb.append("\tAn attempt at spawning a bad ItemStack in the world was intercepted!\n");
            sb.append("\n");
            sb.append("Relevant Data:\n");
            sb.append("--------------------------------------------------\n");
            sb.append("\t- In World: ").append(optWorld.map(w -> w.func_72912_H().toString()).orElse("<NULL>")).append("\n");
            sb.append("\t- At Location: ").append(optPos.map(p -> p.toString()).orElse("<NULL>")).append("\n");
            sb.append("\t- ItemStack:\n");
            sb.append("\t\t- Item: ").append(optStack.map(ItemStack::func_77973_b).map(Item::toString).orElse("<NULL>")).append("\n");
            sb.append("\t\t- Amount: ").append(optStack.map(ItemStack::func_190916_E).map(Object::toString).orElse("<NULL>")).append("\n");
            sb.append("\t\t- Tags: ").append(optStack.map(ItemStack::func_77978_p).map(CompoundNBT::toString).orElse("<NULL>")).append("\n");
            sb.append("\n");
            sb.append("Stacktrace:\n");
            sb.append("--------------------------------------------------\n");
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                sb.append("\t").append(e.toString()).append("\n");
            }
            sb.append("==================================================\n");
            InfinityLib.instance.getLogger().error(sb.toString(), new Object[0]);
        }
    }
}

