/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class NBTHelper {
    public static CompoundNBT writeBoolArray(String key, CompoundNBT tag, boolean[] array) {
        int[] ints = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            ints[i] = array[i] ? 1 : 0;
        }
        tag.func_74783_a(key, ints);
        return tag;
    }

    public static boolean[] readBoolArray(String key, CompoundNBT tag) {
        int[] ints = tag.func_74759_k(key);
        boolean[] array = new boolean[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            array[i] = ints[i] > 0;
        }
        return array;
    }

    public static final void addCoordsToNBT(int[] coords, CompoundNBT tag) {
        if (coords != null && coords.length == 3) {
            NBTHelper.addCoordsToNBT(coords[0], coords[1], coords[2], tag);
        }
    }

    public static final void addCoordsToNBT(int x, int y, int z, CompoundNBT tag) {
        tag.func_74768_a("IL_X", x);
        tag.func_74768_a("IL_Y", y);
        tag.func_74768_a("IL_Z", z);
    }

    public static final int[] getCoordsFromNBT(CompoundNBT tag) {
        int[] coords = null;
        if (tag.func_74764_b("IL_X") && tag.func_74764_b("IL_Y") && tag.func_74764_b("IL_Z")) {
            coords = new int[]{tag.func_74762_e("IL_X"), tag.func_74762_e("IL_Y"), tag.func_74762_e("IL_Z")};
        }
        return coords;
    }

    public static final boolean hasKey(CompoundNBT tag, String ... keys) {
        if (tag == null) {
            return false;
        }
        for (String key : keys) {
            if (tag.func_74764_b(key)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final CompoundNBT asTag(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77978_p();
        }
        if (obj instanceof CompoundNBT) {
            return (CompoundNBT)obj;
        }
        return null;
    }
}

