/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.NetworkWrapperDummy;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.MessageElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class MessageBase {
    private static final Map<Class<? extends MessageBase>, List<MessageElement>> ELEMENT_MAP = Maps.newIdentityHashMap();
    private static final Map<Class<? extends MessageBase>, INetworkWrapper> WRAPPER_MAP = Maps.newIdentityHashMap();
    private INetworkWrapper wrapper;

    public final INetworkWrapper getNetworkWrapper() {
        if (this.wrapper == null) {
            this.wrapper = WRAPPER_MAP.containsKey(this.getClass()) ? WRAPPER_MAP.get(this.getClass()) : NetworkWrapperDummy.getInstance();
        }
        return this.wrapper;
    }

    public abstract NetworkDirection getMessageDirection();

    protected abstract void processMessage(NetworkEvent.Context var1);

    protected List<IMessageSerializer> getNecessarySerializers() {
        return Collections.emptyList();
    }

    public final <REQ extends MessageBase> REQ fromBytes(PacketBuffer buf) {
        Map<Class<? extends MessageBase>, List<MessageElement>> map = ELEMENT_MAP;
        if (ELEMENT_MAP.containsKey(this.getClass())) {
            for (MessageElement element : ELEMENT_MAP.get(this.getClass())) {
                element.readFromByteBuf(buf, this);
            }
        }
        return (REQ)this;
    }

    public final void toBytes(PacketBuffer buf) {
        Map<Class<? extends MessageBase>, List<MessageElement>> map = ELEMENT_MAP;
        if (ELEMENT_MAP.containsKey(this.getClass())) {
            for (MessageElement element : ELEMENT_MAP.get(this.getClass())) {
                element.writeToByteBuf(buf, this);
            }
        }
    }

    public final MessageBase sendToAll() {
        this.getNetworkWrapper().sendToAll(this);
        return this;
    }

    public final MessageBase sendTo(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            this.getNetworkWrapper().sendTo(this, (ServerPlayerEntity)player);
        } else {
            InfinityLib.instance.getLogger().error("Can not send message directly to a player from a client", new Object[0]);
        }
        return this;
    }

    public final MessageBase sendTo(ServerPlayerEntity player) {
        this.getNetworkWrapper().sendTo(this, player);
        return this;
    }

    public final MessageBase sendToAllAround(World world, double x, double y, double z, double range) {
        this.getNetworkWrapper().sendToAllAround(this, world, x, y, z, range);
        return this;
    }

    public final MessageBase sendToAllAround(RegistryKey<World> dimension, double x, double y, double z, double range) {
        this.getNetworkWrapper().sendToAllAround(this, dimension, x, y, z, range);
        return this;
    }

    public final MessageBase sendToAllAround(Supplier<PacketDistributor.TargetPoint> point) {
        this.getNetworkWrapper().sendToAllAround(this, point);
        return this;
    }

    public final MessageBase sendToDimension(World world) {
        this.getNetworkWrapper().sendToDimension(this, world);
        return this;
    }

    public final MessageBase sendToDimension(RegistryKey<World> dimension) {
        this.getNetworkWrapper().sendToDimension(this, dimension);
        return this;
    }

    public final MessageBase sendToServer() {
        this.getNetworkWrapper().sendToServer(this);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final String getServerId() {
        ServerData data = Minecraft.func_71410_x().func_147104_D();
        return "server_" + data.field_78845_b.replaceAll("\\.", "-").replaceAll(":", "_");
    }

    static void onMessageRegistered(Class<? extends MessageBase> clazz, INetworkWrapper wrapper) {
        WRAPPER_MAP.put(clazz, wrapper);
        MessageBase.compileFieldsList(clazz);
    }

    private static void compileFieldsList(Class<? extends MessageBase> clazz) {
        if (!ELEMENT_MAP.containsKey(clazz)) {
            ImmutableList<Field> fields = MessageBase.fetchFieldsRecursively(clazz, (ImmutableList.Builder<Field>)ImmutableList.builder());
            ArrayList elements = Lists.newArrayList();
            ArrayList skippedFields = Lists.newArrayList();
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Optional<MessageElement<?>> element = MessageElement.createNewElement(field);
                if (element.isPresent()) {
                    elements.add(element.get());
                    continue;
                }
                skippedFields.add(field);
            }
            ELEMENT_MAP.put(clazz, (List<MessageElement>)ImmutableList.copyOf((Collection)elements));
            if (skippedFields.size() > 0) {
                InfinityLib.instance.getLogger().error("SKIPPED FIELDS FOR MESSAGE CLASS: " + clazz.getName(), new Object[0]);
                InfinityLib.instance.getLogger().error("Report this to the mod author, skipped fields are:", new Object[0]);
                for (Field field : skippedFields) {
                    InfinityLib.instance.getLogger().error(" - " + field.getName(), new Object[0]);
                }
                InfinityLib.instance.getLogger().error("serializers have to be registered for these field types,", new Object[0]);
                InfinityLib.instance.getLogger().error("this is done via INetworkWrapper.registerDataSerializer", new Object[0]);
            }
        }
    }

    private static ImmutableList<Field> fetchFieldsRecursively(Class<?> clazz, ImmutableList.Builder<Field> builder) {
        if (clazz == null) {
            return builder.build();
        }
        if (!MessageBase.class.isAssignableFrom(clazz)) {
            return builder.build();
        }
        if (clazz == MessageBase.class) {
            return builder.build();
        }
        builder.add((Object[])clazz.getDeclaredFields());
        return MessageBase.fetchFieldsRecursively(clazz.getSuperclass(), builder);
    }
}

