/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.item;

import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.debug.DebugMode;
import com.infinityraider.infinitylib.utility.debug.DebugModeFeedback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemDebuggerBase
extends ItemBase {
    private final List<DebugMode> DEBUG_MODES = new ArrayList<DebugMode>();

    public ItemDebuggerBase() {
        this(true);
    }

    public ItemDebuggerBase(boolean isVanilla) {
        super("debugger", new Item.Properties());
        this.DEBUG_MODES.add(new DebugModeFeedback());
        this.DEBUG_MODES.addAll(this.getDebugModes());
    }

    protected abstract List<DebugMode> getDebugModes();

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                DebugMode mode = this.changeDebugMode(stack);
                player.func_145747_a((ITextComponent)new StringTextComponent("Set debug mode to " + mode.debugName()), Util.field_240973_b_);
            }
        } else {
            this.getDebugMode(stack).debugActionClicked(stack, world, player, hand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() != null && !context.func_195999_j().func_225608_bj_()) {
            ItemStack stack = context.func_195996_i();
            this.getDebugMode(stack).debugActionBlockClicked(stack, context);
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, PlayerEntity player, @Nonnull LivingEntity target, @Nonnull Hand hand) {
        if (!player.func_225608_bj_()) {
            this.getDebugMode(stack).debugActionEntityClicked(stack, player, target, hand);
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        DebugMode mode = this.getDebugMode(stack);
        tooltip.add((ITextComponent)new StringTextComponent("Right Click to use the debugger in its current mode"));
        tooltip.add((ITextComponent)new StringTextComponent("Shift + Right Click to cycle debug modes"));
        tooltip.add((ITextComponent)new StringTextComponent("Current debug mode: " + (mode == null ? "null" : mode.debugName())));
    }

    public DebugMode getDebugMode(ItemStack stack) {
        CompoundNBT tag;
        if (!stack.func_77942_o() || stack.func_77978_p() == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        if (!tag.func_74764_b("IL_Count")) {
            tag.func_74768_a("IL_Count", 0);
        }
        return this.DEBUG_MODES.get(tag.func_74762_e("IL_Count") % this.DEBUG_MODES.size());
    }

    public DebugMode changeDebugMode(ItemStack stack) {
        CompoundNBT tag;
        if (!stack.func_77942_o() || stack.func_77978_p() == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        int index = !tag.func_74764_b("IL_Count") ? 1 : (tag.func_74762_e("IL_Count") + 1) % this.DEBUG_MODES.size();
        tag.func_74768_a("IL_Count", index);
        return this.DEBUG_MODES.get(index);
    }
}

