/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity.ai.pathfinding;

import com.infinityraider.infinitylib.entity.ai.pathfinding.PathFindJob;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class PathCalculator
implements Runnable {
    private static PathCalculator instance;
    private final Deque<PathFindJob> jobs = new ArrayDeque<PathFindJob>();
    private boolean stop = false;
    private boolean stopped = true;
    private boolean cancelJobs = false;

    public static void setInstance(PathCalculator calculator) {
        if (instance != null) {
            instance.cancel();
        }
        instance = calculator;
    }

    public static PathCalculator getInstance() {
        return instance;
    }

    protected PathCalculator() {
    }

    public void calculatePath(MobEntity entity, double x, double y, double z) {
        this.calculatePath(entity, new Vector3d(x, y, z), PathCalculator.defaultOptions());
    }

    public void calculatePath(MobEntity entity, double x, double y, double z, IPathOptions options) {
        this.calculatePath(entity, new Vector3d(x, y, z), options);
    }

    public void calculatePath(MobEntity entity, BlockPos target) {
        this.calculatePath(entity, new Vector3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5), PathCalculator.defaultOptions());
    }

    public void calculatePath(MobEntity entity, Vector3i target, IPathOptions options) {
        this.calculatePath(entity, new Vector3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5), options);
    }

    public void calculatePath(MobEntity entity, Vector3d target) {
        this.calculatePath(entity, target, PathCalculator.defaultOptions());
    }

    public void calculatePath(MobEntity entity, final Vector3d target, IPathOptions options) {
        ITarget iTarget = new ITarget(){

            @Override
            public Vector3d getTarget() {
                return target;
            }

            @Override
            public boolean canTargetMove() {
                return false;
            }

            @Override
            public boolean hasTargetChanged(Vector3d previous) {
                return false;
            }

            @Override
            public boolean isValid() {
                return true;
            }
        };
        this.calculatePath(entity, iTarget, options);
    }

    public void calculatePath(MobEntity entity, Entity target) {
        this.calculatePath(entity, target, PathCalculator.defaultOptions());
    }

    public void calculatePath(MobEntity entity, final Entity target, IPathOptions options) {
        ITarget iTarget = new ITarget(){

            @Override
            public Vector3d getTarget() {
                return target.func_213303_ch();
            }

            @Override
            public boolean canTargetMove() {
                return true;
            }

            @Override
            public boolean hasTargetChanged(Vector3d previous) {
                Vector3d current = this.getTarget();
                double dX = current.field_72450_a - previous.field_72450_a;
                double dY = current.field_72448_b - previous.field_72448_b;
                double dZ = current.field_72449_c - previous.field_72449_c;
                return dX * dX + dY * dY + dZ * dZ >= 1.0;
            }

            @Override
            public boolean isValid() {
                return target.func_70089_S();
            }
        };
        this.calculatePath(entity, iTarget, options);
    }

    public void calculatePath(MobEntity entity, ITarget target) {
        this.calculatePath(entity, target, PathCalculator.defaultOptions());
    }

    public void calculatePath(MobEntity entity, ITarget target, IPathOptions options) {
        this.calculatePath(new PathFindJob(entity, target, options));
    }

    public void calculatePath(PathFindJob job) {
        this.addJob(job);
    }

    public void start() {
        if (this.stopped) {
            this.stop = false;
            new Thread(this).start();
        }
    }

    public void stop() {
        this.stop = true;
    }

    public void cancel() {
        this.cancelJobs = true;
        this.stop();
    }

    @Override
    public final void run() {
        this.stopped = false;
        while (!this.stop) {
            this.processJob(this.jobs.pollFirst());
            if (this.jobs.size() > 0) continue;
            this.stop();
        }
        if (this.cancelJobs) {
            this.jobs.forEach(PathFindJob::cancel);
            this.jobs.clear();
            this.cancelJobs = false;
        }
        this.stopped = true;
    }

    protected boolean addJob(PathFindJob job) {
        if (this.cancelJobs) {
            return false;
        }
        this.jobs.add(job);
        if (this.stopped) {
            this.start();
        }
        return true;
    }

    protected void processJob(PathFindJob job) {
        if (job != null && job.isValid()) {
            this.determinePath(job).map(path -> {
                job.finish((Path)path);
                return job;
            }).orElseGet(() -> {
                job.fail();
                return job;
            });
        }
    }

    protected Optional<Path> determinePath(PathFindJob job) {
        return Optional.empty();
    }

    public static PathOptionsConfigurator configurator() {
        return new PathOptionsConfigurator();
    }

    public static IPathOptions defaultOptions() {
        return PathCalculator.configurator().configure();
    }

    static {
        PathCalculator.setInstance(new PathCalculator());
    }

    public static class PathOptionsConfigurator {
        private boolean canOpenDoors = false;
        private boolean canClimbLadders = false;
        private boolean canClimbWalls = false;
        private boolean canSwim = false;
        private boolean canFly = false;
        private int maxFallHeight = 1;
        private int maxJumpHeight = 1;

        private PathOptionsConfigurator() {
        }

        public PathOptionsConfigurator setCanOpenDoors(boolean value) {
            this.canOpenDoors = value;
            return this;
        }

        public PathOptionsConfigurator setCanClimbLadders(boolean value) {
            this.canClimbLadders = value;
            return this;
        }

        public PathOptionsConfigurator setCanClimbWalls(boolean value) {
            this.canClimbWalls = value;
            return this;
        }

        public PathOptionsConfigurator setCanSwim(boolean value) {
            this.canSwim = value;
            return this;
        }

        public PathOptionsConfigurator setCanFly(boolean value) {
            this.canFly = value;
            return this;
        }

        public PathOptionsConfigurator setMaxFallHeight(int value) {
            this.maxFallHeight = value;
            return this;
        }

        public PathOptionsConfigurator setMaxJumpHeight(int value) {
            this.maxJumpHeight = value;
            return this;
        }

        public IPathOptions configure() {
            return new IPathOptions(){

                @Override
                public boolean canOpenDoors() {
                    return canOpenDoors;
                }

                @Override
                public boolean canClimbLadders() {
                    return canClimbLadders;
                }

                @Override
                public boolean canClimbWalls() {
                    return canClimbWalls;
                }

                @Override
                public boolean canSwim() {
                    return canSwim;
                }

                @Override
                public boolean canFly() {
                    return canFly;
                }

                @Override
                public int maxFallHeight() {
                    return maxFallHeight;
                }

                @Override
                public int maxJumpHeight() {
                    return maxJumpHeight;
                }
            };
        }
    }

    public static interface IPathOptions {
        public boolean canOpenDoors();

        public boolean canClimbLadders();

        public boolean canClimbWalls();

        public boolean canSwim();

        public boolean canFly();

        public int maxFallHeight();

        public int maxJumpHeight();
    }

    public static interface ITarget {
        public Vector3d getTarget();

        default public PathPoint getTargetPoint() {
            Vector3d target = this.getTarget();
            return new PathPoint(MathHelper.func_76128_c((double)target.field_72450_a), MathHelper.func_76128_c((double)target.field_72448_b), MathHelper.func_76128_c((double)target.field_72449_c));
        }

        public boolean canTargetMove();

        public boolean hasTargetChanged(Vector3d var1);

        public boolean isValid();
    }
}

