/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.crafting.fallback;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class FallbackIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "fallback");
    public static final Serializer SERIALIZER = new Serializer();
    private final ITag<Item> tag;
    private final Ingredient fallback;
    private Ingredient ingredient;

    public FallbackIngredient(ITag<Item> tag, Ingredient fallback) {
        super(Stream.empty());
        this.tag = tag;
        this.fallback = fallback;
    }

    protected ITag<Item> getTag() {
        return this.tag;
    }

    protected Ingredient getFallback() {
        return this.fallback;
    }

    private Ingredient getActualIngredient() {
        if (this.ingredient == null) {
            if (this.getTag() != null && this.getTag().func_230236_b_().size() > 0) {
                this.ingredient = Ingredient.func_199805_a(this.getTag());
            } else {
                if (this.getFallback().func_203189_d()) {
                    return field_193370_a;
                }
                this.ingredient = this.getFallback();
            }
        }
        return this.ingredient;
    }

    public ItemStack[] func_193365_a() {
        return this.getActualIngredient().func_193365_a();
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.getActualIngredient().test(stack);
    }

    public IntList func_194139_b() {
        return this.getActualIngredient().func_194139_b();
    }

    public JsonElement func_200304_c() {
        JsonObject rootJson = new JsonObject();
        JsonObject ingredientJson = new JsonObject();
        ResourceLocation rl = ItemTags.func_199903_a().func_232973_a_(this.getTag());
        ingredientJson.addProperty("tag", rl.toString());
        ingredientJson.add("fallback", this.getFallback().func_200304_c());
        rootJson.add("ingredient", (JsonElement)ingredientJson);
        rootJson.addProperty("type", InfinityLib.instance.getModId() + ":fallback");
        return rootJson;
    }

    public boolean func_203189_d() {
        return this.getActualIngredient().func_203189_d();
    }

    protected void invalidate() {
        this.ingredient = null;
    }

    public boolean isSimple() {
        return this.getActualIngredient().isSimple();
    }

    public IIngredientSerializer<FallbackIngredient> getSerializer() {
        return SERIALIZER;
    }

    public static void registerSerializer() {
    }

    private static final class Serializer
    implements IInfIngredientSerializer<FallbackIngredient> {
        private Serializer() {
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        public FallbackIngredient parse(PacketBuffer buffer) {
            boolean flag = buffer.readBoolean();
            ITag tag = null;
            if (flag) {
                ResourceLocation rl = buffer.func_192575_l();
                tag = ItemTags.func_199903_a().func_241834_b(rl);
            }
            Ingredient fallback = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new FallbackIngredient((ITag<Item>)tag, fallback);
        }

        public FallbackIngredient parse(JsonObject json) {
            if (!json.has("ingredient")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.FallBackIngredient requires an ingredient element");
            }
            JsonElement element = json.get("ingredient");
            if (!(element instanceof JsonObject)) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.FallBackIngredient expected an object for ingredient");
            }
            JsonObject ingredientJson = (JsonObject)element;
            if (!ingredientJson.has("tag")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.FallBackIngredient requires a tag element");
            }
            if (!ingredientJson.has("fallback")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.FallBackIngredient requires a fallback element");
            }
            ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)ingredientJson, (String)"tag"));
            ITag tag = ItemTags.func_199903_a().func_241834_b(rl);
            Ingredient fallback = CraftingHelper.getIngredient((JsonElement)ingredientJson.get("fallback"));
            return new FallbackIngredient((ITag<Item>)tag, fallback);
        }

        public void write(PacketBuffer buffer, FallbackIngredient ingredient) {
            ResourceLocation rl = ItemTags.func_199903_a().func_232973_a_(ingredient.getTag());
            boolean flag = rl != null;
            buffer.writeBoolean(flag);
            if (flag) {
                buffer.func_192572_a(rl);
            }
            ingredient.getFallback().func_199564_a(buffer);
        }
    }
}

