/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.crafting.dynamictexture;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.dynamictexture.DynamicTextureIngredient;
import com.infinityraider.infinitylib.crafting.dynamictexture.IDynamicTextureIngredient;
import com.infinityraider.infinitylib.item.BlockItemDynamicTexture;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicTextureParentIngredient
extends Ingredient
implements IDynamicTextureIngredient {
    public static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "dynamic_material_parent");
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack parent;
    private final DynamicTextureIngredient.BlockTagList tagList;

    protected DynamicTextureParentIngredient(ItemStack parent, ResourceLocation tagId) {
        this(parent, new DynamicTextureIngredient.BlockTagList(tagId));
    }

    protected DynamicTextureParentIngredient(ItemStack parent, DynamicTextureIngredient.BlockTagList tagList) {
        super(Stream.of(new Ingredient.SingleItemList(parent)));
        this.parent = parent;
        this.tagList = tagList;
    }

    public ItemStack getParent() {
        return this.parent;
    }

    @Override
    public ResourceLocation getTagId() {
        return this.tagList.getTagId();
    }

    @Override
    public ITag<Block> getTag() {
        return this.tagList.getTag();
    }

    @Override
    public ItemStack asStackWithMaterial(ItemStack material) {
        ItemStack stack = this.getParent().func_77946_l();
        if (stack.func_77973_b() instanceof BlockItemDynamicTexture) {
            ((BlockItemDynamicTexture)stack.func_77973_b()).setMaterial(stack, material);
        }
        return stack;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItemDynamicTexture;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static final class Serializer
    implements IInfIngredientSerializer<DynamicTextureParentIngredient> {
        private Serializer() {
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        public DynamicTextureParentIngredient parse(PacketBuffer buffer) {
            return new DynamicTextureParentIngredient(buffer.func_150791_c(), buffer.func_192575_l());
        }

        public DynamicTextureParentIngredient parse(JsonObject json) {
            if (!json.has("parent")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.DynamicTextureParentIngredient requires a parent element");
            }
            if (!json.has("material")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.DynamicTextureParentIngredient requires a material element");
            }
            ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"parent"));
            Item parent = (Item)Optional.ofNullable(ForgeRegistries.ITEMS.getValue(rl)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + rl + "'"));
            return new DynamicTextureParentIngredient(new ItemStack((IItemProvider)parent), new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"material")));
        }

        public void write(PacketBuffer buffer, DynamicTextureParentIngredient ingredient) {
            buffer.func_150788_a(ingredient.getParent());
            buffer.func_192572_a(ingredient.getTagId());
        }
    }
}

