/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.capability;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.capability.CapabilityProvider;
import com.infinityraider.infinitylib.capability.CapabilityStorage;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import com.infinityraider.infinitylib.capability.IInfCapabilityImplementation;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityHandler {
    private static final CapabilityHandler INSTANCE = new CapabilityHandler();
    private final Set<ICapabilityImplementation<ICapabilityProvider, ?>> capabilityImplementations = Sets.newConcurrentHashSet();

    public static CapabilityHandler getInstance() {
        return INSTANCE;
    }

    private CapabilityHandler() {
        InfinityLib.instance.registerEventHandler(this);
    }

    public <T extends ICapabilityProvider, C> void registerCapability(ICapabilityImplementation<T, C> implementation) {
        this.capabilityImplementations.add(implementation);
        if (implementation instanceof IInfCapabilityImplementation) {
            IInfCapabilityImplementation infImpl = (IInfCapabilityImplementation)implementation;
            CapabilityManager.INSTANCE.register(infImpl.getCapabilityClass(), new CapabilityStorage(infImpl.getSerializer()), infImpl.factory());
        }
    }

    protected <T extends ICapabilityProvider, C> void addCapability(AttachCapabilitiesEvent<?> event, ICapabilityImplementation<T, C> implementation, T carrier) {
        event.addCapability(implementation.getCapabilityKey(), new CapabilityProvider(implementation::getCapability, implementation.createNewValue(carrier)));
    }

    protected <T extends ICapabilityProvider> void addCapabilities(AttachCapabilitiesEvent<T> event) {
        ICapabilityProvider carrier = (ICapabilityProvider)event.getObject();
        Class<?> clazz = carrier.getClass();
        this.capabilityImplementations.stream().filter(impl -> impl.getCarrierClass().isAssignableFrom(clazz)).filter(impl -> impl.shouldApplyCapability(carrier)).forEach(impl -> this.addCapability(event, (ICapabilityImplementation)impl, (ICapabilityProvider)carrier));
    }

    @SubscribeEvent
    public void addCapabilitiesRaw(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof ICapabilityProvider) {
            this.addCapabilities(event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        PlayerEntity newPlayer = event.getPlayer();
        if (oldPlayer != null && newPlayer != null && !oldPlayer.func_130014_f_().field_72995_K) {
            this.capabilityImplementations.stream().filter(impl -> PlayerEntity.class.isAssignableFrom(impl.getCarrierClass())).filter(impl -> impl instanceof IInfCapabilityImplementation).map(impl -> (IInfCapabilityImplementation)impl).forEach(impl -> oldPlayer.getCapability(impl.getCapability(), null).ifPresent(oldProps -> newPlayer.getCapability(impl.getCapability(), null).ifPresent(newProps -> impl.copyData(oldProps, newProps))));
        }
    }
}

