/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block.tile;

import com.google.common.collect.Maps;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.network.MessageAutoSyncTileField;
import com.infinityraider.infinitylib.network.MessageRenderUpdate;
import com.infinityraider.infinitylib.network.MessageSyncTile;
import com.infinityraider.infinitylib.proxy.IProxy;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;

public abstract class TileEntityBase
extends TileEntity {
    private static final Random RANDOM = new Random();
    private final Map<Integer, AutoSyncedField<?>> syncedFields = Maps.newHashMap();

    public TileEntityBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public final int xCoord() {
        return this.func_174877_v().func_177958_n();
    }

    public final int yCoord() {
        return this.func_174877_v().func_177956_o();
    }

    public final int zCoord() {
        return this.func_174877_v().func_177952_p();
    }

    public final Chunk getChunk() {
        if (this.func_145831_w() == null) {
            return null;
        }
        return this.func_145831_w().func_175726_f(this.func_174877_v());
    }

    public Random getRandom() {
        return this.func_145831_w() == null ? RANDOM : this.func_145831_w().field_73012_v;
    }

    public boolean isRemote() {
        return this.func_145831_w() != null && this.func_145831_w().field_72995_K;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return tag;
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket pkt) {
        if (this.func_145831_w() == null) {
            return;
        }
        BlockState before = this.func_195044_w();
        this.func_230337_a_(before, pkt.func_148857_g());
        BlockState after = this.func_145831_w().func_180495_p(pkt.func_179823_a());
        if (!after.equals(before)) {
            this.func_145831_w().func_225319_b(pkt.func_179823_a(), before, after);
        }
    }

    @Nonnull
    public final CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        super.func_189515_b(tag);
        this.syncedFields.values().forEach(field -> tag.func_218657_a("IL_FIELD_" + field.getId(), (INBT)field.serialize()));
        this.writeTileNBT(tag);
        return tag;
    }

    public final void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.syncedFields.values().forEach(field -> {
            String key = "IL_FIELD_" + field.getId();
            if (tag.func_74764_b(key)) {
                field.deserialize(tag.func_74775_l(key));
            }
        });
        this.readTileNBT(state, tag);
    }

    protected abstract void writeTileNBT(@Nonnull CompoundNBT var1);

    protected abstract void readTileNBT(@Nonnull BlockState var1, @Nonnull CompoundNBT var2);

    public void markForUpdateAndNotify() {
        if (this.func_145831_w() != null) {
            BlockState state = this.func_195044_w();
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            this.func_70296_d();
        }
    }

    public void syncToClient() {
        this.syncToClient(false);
    }

    public void syncToClient(boolean renderUpdate) {
        World world = this.func_145831_w();
        if (world != null && !this.func_145831_w().field_72995_K) {
            new MessageSyncTile(this, renderUpdate).sendToAllAround(this.func_145831_w(), (double)this.xCoord(), (double)this.yCoord(), (double)this.zCoord(), 128.0);
        }
    }

    public void forceRenderUpdate() {
        if (this.isRemote()) {
            ((IProxy)InfinityLib.instance.proxy()).forceClientRenderUpdate(this.func_174877_v());
        } else if (this.func_145831_w() != null) {
            new MessageRenderUpdate(this.func_174877_v()).sendToDimension(this.func_145831_w());
        }
    }

    public <F> AutoSyncedField<F> getField(int id) {
        return this.syncedFields.get(id);
    }

    protected <F> AutoSyncedField<F> createAutoSyncedField(F value, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer) {
        return this.getAutoSyncedFieldBuilder(value, serializer, deserializer).build();
    }

    protected <F> AutoSyncedField<F> createAutoSyncedField(F value, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer, BooleanSupplier checker, F fallback) {
        return this.getAutoSyncedFieldBuilder(value, serializer, deserializer).withDelay(checker, fallback).build();
    }

    public <F> AutoSyncedFieldBuilder<F> getAutoSyncedFieldBuilder(F value, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer, BooleanSupplier checker, F fallback) {
        return new AutoSyncedFieldBuilder<F>(value, this, serializer, deserializer).withDelay(checker, fallback);
    }

    public <F> AutoSyncedFieldBuilder<F> getAutoSyncedFieldBuilder(F value, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer) {
        return new AutoSyncedFieldBuilder(value, this, serializer, deserializer);
    }

    public AutoSyncedFieldBuilder<Boolean> getAutoSyncedFieldBuilder(boolean value) {
        return new AutoSyncedFieldBuilder<Boolean>(value, this, (b, tag) -> tag.func_74757_a("IL_VALUE", b.booleanValue()), tag -> tag.func_74764_b("IL_VALUE") ? tag.func_74767_n("IL_VALUE") : value);
    }

    public AutoSyncedFieldBuilder<Integer> getAutoSyncedFieldBuilder(int value) {
        return new AutoSyncedFieldBuilder<Integer>(value, this, (i, tag) -> tag.func_74768_a("IL_VALUE", i.intValue()), tag -> tag.func_74764_b("IL_VALUE") ? tag.func_74762_e("IL_VALUE") : value);
    }

    public AutoSyncedFieldBuilder<Float> getAutoSyncedFieldBuilder(float value) {
        return new AutoSyncedFieldBuilder<Float>(Float.valueOf(value), this, (f, tag) -> tag.func_74776_a("IL_VALUE", f.floatValue()), tag -> Float.valueOf(tag.func_74764_b("IL_VALUE") ? tag.func_74760_g("IL_VALUE") : value));
    }

    public AutoSyncedFieldBuilder<Double> getAutoSyncedFieldBuilder(double value) {
        return new AutoSyncedFieldBuilder<Double>(value, this, (d, tag) -> tag.func_74780_a("IL_VALUE", d.doubleValue()), tag -> tag.func_74764_b("IL_VALUE") ? tag.func_74769_h("IL_VALUE") : value);
    }

    public AutoSyncedFieldBuilder<String> getAutoSyncedFieldBuilder(String value) {
        return new AutoSyncedFieldBuilder<String>(value, this, (s, tag) -> tag.func_74778_a("IL_VALUE", s), tag -> tag.func_74764_b("IL_VALUE") ? tag.func_74779_i("IL_VALUE") : value);
    }

    public AutoSyncedFieldBuilder<ItemStack> getAutoSyncedFieldBuilder(ItemStack value) {
        return new AutoSyncedFieldBuilder<ItemStack>(value, this, ItemStack::func_77955_b, ItemStack::func_199557_a);
    }

    public AutoSyncedFieldBuilder<BlockPos> getAutoSyncedFieldBuilder(BlockPos value) {
        return new AutoSyncedFieldBuilder<BlockPos>(value, this, (pos, tag) -> {
            tag.func_74768_a("IL_X", pos.func_177958_n());
            tag.func_74768_a("IL_Y", pos.func_177956_o());
            tag.func_74768_a("IL_Z", pos.func_177952_p());
        }, tag -> {
            if (tag.func_74764_b("IL_X") && tag.func_74764_b("IL_Y") && tag.func_74764_b("IL_Z")) {
                return new BlockPos(tag.func_74762_e("IL_X"), tag.func_74762_e("IL_Y"), tag.func_74762_e("IL_Z"));
            }
            return this.func_174877_v();
        });
    }

    protected static class AutoSyncedFieldDelayed<F>
    extends AutoSyncedField<F> {
        private final BooleanSupplier checker;
        private final F fallback;
        private CompoundNBT data;

        private AutoSyncedFieldDelayed(F value, TileEntityBase tile, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer, Consumer<F> callback, Predicate<F> renderUpdateChecker, BooleanSupplier checker, F fallback) {
            super(value, tile, serializer, deserializer, callback, renderUpdateChecker);
            this.checker = checker;
            this.fallback = fallback;
        }

        @Override
        protected void setInternal(F value) {
            this.data = null;
            super.setInternal(value);
        }

        @Override
        public F get() {
            if (this.data == null) {
                return super.get();
            }
            if (this.isReady()) {
                this.deserialize(this.data);
                this.data = null;
                if (this.getSide().isServer()) {
                    this.sync();
                }
                return this.get();
            }
            return this.fallback;
        }

        @Override
        public void deserialize(CompoundNBT tag) {
            if (this.isReady()) {
                super.deserialize(tag);
            } else {
                this.data = tag.func_74737_b();
            }
        }

        @Override
        public CompoundNBT serialize() {
            if (this.data == null) {
                return super.serialize();
            }
            if (this.isReady()) {
                super.deserialize(this.data);
                this.data = null;
                return super.serialize();
            }
            return this.data;
        }

        protected boolean isReady() {
            return this.checker.getAsBoolean();
        }
    }

    public static class AutoSyncedField<F> {
        private F value;
        private final int id;
        private final TileEntityBase tile;
        private final LogicalSide side;
        private final BiConsumer<F, CompoundNBT> serializer;
        private final Function<CompoundNBT, F> deserializer;
        private final Consumer<F> callback;
        private final Predicate<F> renderUpdateChecker;

        private AutoSyncedField(F value, TileEntityBase tile, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer, Consumer<F> callback, Predicate<F> renderUpdateChecker) {
            this.value = value;
            this.id = tile.syncedFields.size();
            tile.syncedFields.put(this.getId(), this);
            this.tile = tile;
            this.side = ((IProxy)InfinityLib.instance.proxy()).getLogicalSide();
            this.serializer = serializer;
            this.deserializer = deserializer;
            this.callback = callback;
            this.renderUpdateChecker = renderUpdateChecker;
        }

        public void set(F value) {
            if (this.getSide().isServer() && !this.get().equals(value)) {
                this.setInternal(value);
                this.sync();
                this.getTile().func_70296_d();
            }
        }

        protected void setInternal(F value) {
            if (this.value == value) {
                return;
            }
            this.value = value;
            this.callback.accept(value);
            if (this.getSide().isClient() && this.renderUpdateChecker.test(value)) {
                this.getTile().forceRenderUpdate();
            }
        }

        public F get() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        public TileEntityBase getTile() {
            return this.tile;
        }

        public LogicalSide getSide() {
            return this.side;
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            this.serializer.accept(this.get(), tag);
            return tag;
        }

        public void deserialize(CompoundNBT tag) {
            this.setInternal(this.deserializer.apply(tag));
        }

        protected void sync() {
            new MessageAutoSyncTileField(this).sendToAll();
        }
    }

    public static class AutoSyncedFieldBuilder<F> {
        private final F value;
        private final TileEntityBase tile;
        private final BiConsumer<F, CompoundNBT> serializer;
        private final Function<CompoundNBT, F> deserializer;
        private Consumer<F> callback;
        private Predicate<F> renderUpdateChecker;
        private boolean delayed;
        private BooleanSupplier delayedCheck;
        private F fallbackValue;

        private AutoSyncedFieldBuilder(F value, TileEntityBase tile, BiConsumer<F, CompoundNBT> serializer, Function<CompoundNBT, F> deserializer) {
            this.value = value;
            this.tile = tile;
            this.serializer = serializer;
            this.deserializer = deserializer;
            this.callback = f -> {};
            this.renderUpdateChecker = f -> false;
            this.delayed = false;
        }

        public AutoSyncedFieldBuilder<F> withCallBack(Consumer<F> callback) {
            this.callback = callback;
            return this;
        }

        public AutoSyncedFieldBuilder<F> withRenderUpdate() {
            return this.withRenderUpdate(f -> true);
        }

        public AutoSyncedFieldBuilder<F> withRenderUpdate(Predicate<F> renderUpdateChecker) {
            this.renderUpdateChecker = renderUpdateChecker;
            return this;
        }

        public AutoSyncedFieldBuilder<F> withDelay(BooleanSupplier isReady, F tempValue) {
            this.delayed = true;
            this.delayedCheck = isReady;
            this.fallbackValue = tempValue;
            return this;
        }

        public AutoSyncedField<F> build() {
            if (this.delayed) {
                return new AutoSyncedFieldDelayed(this.value, this.tile, this.serializer, this.deserializer, this.callback, this.renderUpdateChecker, this.delayedCheck, this.fallbackValue);
            }
            return new AutoSyncedField(this.value, this.tile, this.serializer, this.deserializer, this.callback, this.renderUpdateChecker);
        }
    }
}

