/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block;

import com.google.common.collect.Lists;
import com.infinityraider.infinitylib.block.BlockBaseTile;
import com.infinityraider.infinitylib.block.tile.TileEntityDynamicTexture;
import com.infinityraider.infinitylib.item.BlockItemDynamicTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public abstract class BlockDynamicTexture<T extends TileEntityDynamicTexture>
extends BlockBaseTile<T> {
    public BlockDynamicTexture(String name, AbstractBlock.Properties properties) {
        super(name, properties);
    }

    @Nonnull
    public BlockItemDynamicTexture asItem() {
        return (BlockItemDynamicTexture)super.func_199767_j();
    }

    public final void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.func_201670_d() && stack.func_77973_b() instanceof BlockItemDynamicTexture && tile instanceof TileEntityDynamicTexture) {
            TileEntityDynamicTexture dynTile = (TileEntityDynamicTexture)tile;
            dynTile.setMaterial(((BlockItemDynamicTexture)stack.func_77973_b()).getMaterial(stack));
        }
        this.onBlockPlacedBy(world, pos, state, placer, stack, tile);
    }

    @Nonnull
    @Deprecated
    public final List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        ArrayList drops = Lists.newArrayList();
        TileEntity tile = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntityDynamicTexture) {
            BlockItemDynamicTexture item = this.asItem();
            ItemStack stack = new ItemStack((IItemProvider)item);
            item.setMaterial(stack, ((TileEntityDynamicTexture)tile).getMaterial());
            drops.add(stack);
            this.addDrops(drops::add, state, (TileEntityDynamicTexture)tile, context);
        }
        return drops;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDynamicTexture) {
            TileEntityDynamicTexture dynTile = (TileEntityDynamicTexture)tile;
            ItemStack stack = new ItemStack((IItemProvider)this.asItem(), 1);
            this.asItem().setMaterial(stack, dynTile.getMaterial());
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public abstract void addDrops(Consumer<ItemStack> var1, BlockState var2, T var3, LootContext.Builder var4);

    public abstract void onBlockPlacedBy(World var1, BlockPos var2, BlockState var3, @Nullable LivingEntity var4, ItemStack var5, @Nullable TileEntity var6);
}

