/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentApplicatorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class EnchantmentApplicatorTile
extends IndustrialProcessingTile<EnchantmentApplicatorTile> {
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputFirst;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputSecond;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> output;
    @Save
    private SidedFluidTankComponent<EnchantmentApplicatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentApplicatorConfig.tankSize, 34, 20, 0).setColor(DyeColor.LIME).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207185_a(IndustrialTags.Fluids.EXPERIENCE));

    public EnchantmentApplicatorTile() {
        super(ModuleMisc.ENCHANTMENT_APPLICATOR, 112, 40);
        this.addTank(this.tank);
        this.inputFirst = (SidedInventoryComponent)new SidedInventoryComponent("inputFirst", 60, 40, 1, 1).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> !stack.func_77973_b().equals(Items.field_151134_bR)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputFirst);
        this.inputSecond = (SidedInventoryComponent)new SidedInventoryComponent("inputSecond", 85, 40, 1, 2).setColor(DyeColor.MAGENTA).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputSecond);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 145, 40, 1, 3).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        Pair<ItemStack, Integer> output = this.updateRepairOutput();
        long amount = this.tank.getFluidAmount();
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tileEntity != null && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            amount += (long)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(iFluidHandler -> iFluidHandler.drain(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE).getAmount()).orElse(0).intValue();
        }
        return !((ItemStack)output.getLeft()).func_190926_b() && amount >= (long)this.getEssenceConsumed((Integer)output.getRight()) && this.output.getStackInSlot(0).func_190926_b();
    }

    private int getEssenceConsumed(int experienceLevel) {
        long xp = 0L;
        if (experienceLevel >= 0 && experienceLevel <= 16) {
            xp = (long)(Math.pow(experienceLevel, 2.0) + (double)(6 * experienceLevel));
        }
        if (experienceLevel >= 17 && experienceLevel <= 31) {
            xp = (long)(2.5 * Math.pow(experienceLevel, 2.0) - 40.5 * (double)experienceLevel + 360.0);
        }
        if (experienceLevel >= 32) {
            xp = (long)(4.5 * Math.pow(experienceLevel, 2.0) - 162.5 * (double)experienceLevel + 2220.0);
        }
        return (xp *= 20L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xp;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            Pair<ItemStack, Integer> output = this.updateRepairOutput();
            this.inputFirst.setStackInSlot(0, ItemStack.field_190927_a);
            this.inputSecond.getStackInSlot(0).func_190918_g(1);
            this.output.setStackInSlot(0, (ItemStack)output.getLeft());
            AtomicInteger amount = new AtomicInteger(this.getEssenceConsumed((Integer)output.getRight()));
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (tileEntity != null) {
                tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(iFluidHandler -> amount.addAndGet(-iFluidHandler.drain(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), amount.get()), IFluidHandler.FluidAction.EXECUTE).getAmount()));
            }
            if (amount.get() > 0) {
                this.tank.drainForced(amount.get(), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentApplicatorConfig.powerPerTick;
    }

    public EnchantmentApplicatorTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<EnchantmentApplicatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentApplicatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentApplicatorConfig.maxProgress;
    }

    public Pair<ItemStack, Integer> updateRepairOutput() {
        ItemStack inputFirst = this.inputFirst.getStackInSlot(0);
        int maximumCost = 1;
        int i = 0;
        int j = 0;
        int k = 0;
        if (inputFirst.func_190926_b()) {
            return Pair.of((Object)ItemStack.field_190927_a, (Object)0);
        }
        ItemStack inputFirstCopy = inputFirst.func_77946_l();
        ItemStack inputSecond = this.inputSecond.getStackInSlot(0);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)inputFirstCopy);
        j = j + inputFirst.func_82838_A() + (inputSecond.func_190926_b() ? 0 : inputSecond.func_82838_A());
        boolean addEnchantment = false;
        if (!inputSecond.func_190926_b()) {
            boolean bl = addEnchantment = inputSecond.func_77973_b() == Items.field_151134_bR && !EnchantedBookItem.func_92110_g((ItemStack)inputSecond).isEmpty();
            if (inputFirstCopy.func_77984_f() && inputFirstCopy.func_77973_b().func_82789_a(inputFirst, inputSecond)) {
                int l2 = Math.min(inputFirstCopy.func_77952_i(), inputFirstCopy.func_77958_k() / 4);
                if (l2 <= 0) {
                    return Pair.of((Object)ItemStack.field_190927_a, (Object)0);
                }
                for (int i3 = 0; l2 > 0 && i3 < inputSecond.func_190916_E(); ++i3) {
                    int j3 = inputFirstCopy.func_77952_i() - l2;
                    inputFirstCopy.func_196085_b(j3);
                    ++i;
                    l2 = Math.min(inputFirstCopy.func_77952_i(), inputFirstCopy.func_77958_k() / 4);
                }
            } else {
                if (!(addEnchantment || inputFirstCopy.func_77973_b() == inputSecond.func_77973_b() && inputFirstCopy.func_77984_f())) {
                    return Pair.of((Object)ItemStack.field_190927_a, (Object)0);
                }
                if (inputFirstCopy.func_77984_f() && !addEnchantment) {
                    int l = inputFirst.func_77958_k() - inputFirst.func_77952_i();
                    int i1 = inputSecond.func_77958_k() - inputSecond.func_77952_i();
                    int j1 = i1 + inputFirstCopy.func_77958_k() * 12 / 100;
                    int k1 = l + j1;
                    int l1 = inputFirstCopy.func_77958_k() - k1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (l1 < inputFirstCopy.func_77952_i()) {
                        inputFirstCopy.func_196085_b(l1);
                        i += 2;
                    }
                }
                Map map1 = EnchantmentHelper.func_82781_a((ItemStack)inputSecond);
                boolean flag2 = false;
                boolean flag3 = false;
                for (Enchantment enchantment1 : map1.keySet()) {
                    int j2;
                    if (enchantment1 == null) continue;
                    int enchantmentValue = map.getOrDefault(enchantment1, 0);
                    j2 = enchantmentValue == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, enchantmentValue);
                    boolean flag1 = enchantment1.func_92089_a(inputFirst);
                    for (Enchantment enchantment : map.keySet()) {
                        if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment)) continue;
                        flag1 = false;
                        ++i;
                    }
                    if (!flag1) {
                        flag3 = true;
                        continue;
                    }
                    flag2 = true;
                    if (!EnchantmentApplicatorConfig.ignoreEnchantMaxLevels && j2 > enchantment1.func_77325_b()) {
                        j2 = enchantment1.func_77325_b();
                    }
                    map.put(enchantment1, j2);
                    int enchantmentRarity = 0;
                    switch (enchantment1.func_77324_c()) {
                        case COMMON: {
                            enchantmentRarity = 1;
                            break;
                        }
                        case UNCOMMON: {
                            enchantmentRarity = 2;
                            break;
                        }
                        case RARE: {
                            enchantmentRarity = 4;
                            break;
                        }
                        case VERY_RARE: {
                            enchantmentRarity = 8;
                        }
                    }
                    if (addEnchantment) {
                        enchantmentRarity = Math.max(1, enchantmentRarity / 2);
                    }
                    i += enchantmentRarity * j2;
                    if (inputFirst.func_190916_E() <= 1) continue;
                    i = 40;
                }
                if (flag3 && !flag2) {
                    return Pair.of((Object)ItemStack.field_190927_a, (Object)0);
                }
            }
        }
        if (addEnchantment && !inputFirstCopy.isBookEnchantable(inputSecond)) {
            inputFirstCopy = ItemStack.field_190927_a;
        }
        maximumCost = j + i;
        if (i <= 0) {
            inputFirstCopy = ItemStack.field_190927_a;
        }
        if (!inputFirstCopy.func_190926_b()) {
            int repairCost = inputFirstCopy.func_82838_A();
            if (!inputSecond.func_190926_b() && repairCost < inputSecond.func_82838_A()) {
                repairCost = inputSecond.func_82838_A();
            }
            if (k != i || k == 0) {
                repairCost = RepairContainer.func_216977_d((int)repairCost);
            }
            inputFirstCopy.func_82841_c(repairCost);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)inputFirstCopy);
        }
        return Pair.of((Object)inputFirstCopy, (Object)maximumCost);
    }
}

